/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u0013H\u0016Ja\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\n\u0010\u001b\u001a\u00060\u001cR\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0017\u0012\u0004\u0012\u00020\u001a0\u00132\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\t0\u0013\u00a2\u0006\u0002\b J \u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lavail/interpreter/levelTwo/operation/L2_BIT_LOGIC_OP;", "Lavail/interpreter/levelTwo/L2Operation;", "name", "", "jvmOpcodes", "", "", "(Ljava/lang/String;[I)V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "generateBinaryIntOperation", "arguments", "", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "argumentTypes", "Lavail/descriptor/types/A_Type;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "Lavail/optimizer/L1Translator;", "typeGuaranteeFunction", "fallbackBody", "Lkotlin/ExtensionFunctionType;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "Companion", "avail"})
public final class L2_BIT_LOGIC_OP
extends L2Operation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] jvmOpcodes;
    @NotNull
    private static final L2_BIT_LOGIC_OP bitwiseAnd;
    @NotNull
    private static final L2_BIT_LOGIC_OP bitwiseOr;
    @NotNull
    private static final L2_BIT_LOGIC_OP bitwiseXor;
    @NotNull
    private static final L2_BIT_LOGIC_OP wrappedAdd;
    @NotNull
    private static final L2_BIT_LOGIC_OP wrappedSubtract;
    @NotNull
    private static final L2_BIT_LOGIC_OP wrappedMultiply;
    @NotNull
    private static final L2_BIT_LOGIC_OP wrappedDivide;
    @NotNull
    private static final L2_BIT_LOGIC_OP bitwiseUnsignedShiftRight;
    @NotNull
    private static final L2_BIT_LOGIC_OP bitwiseSignedShiftRight;

    public L2_BIT_LOGIC_OP(@NotNull String name2, int ... jvmOpcodes) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(jvmOpcodes, "jvmOpcodes");
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_INT.named("input1"), L2OperandType.READ_INT.named("input2"), L2OperandType.WRITE_INT.named("output")};
        super("BIT_LOGIC_OP(" + name2 + ")", l2NamedOperandTypeArray);
        this.jvmOpcodes = jvmOpcodes;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadIntOperand input1 = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand input2 = (L2ReadIntOperand)instruction2.operand(1);
        L2WriteIntOperand output = (L2WriteIntOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(output.registerString());
        builder2.append(" \u2190 ");
        builder2.append(input1.registerString());
        builder2.append(" " + this.getName() + " ");
        builder2.append(input2.registerString());
    }

    public final boolean generateBinaryIntOperation(@NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator.CallSiteHelper callSiteHelper, @NotNull Function1<? super List<? extends A_Type>, ? extends A_Type> typeGuaranteeFunction, @NotNull Function1<? super L1Translator, Unit> fallbackBody) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        Intrinsics.checkNotNullParameter(typeGuaranteeFunction, "typeGuaranteeFunction");
        Intrinsics.checkNotNullParameter(fallbackBody, "fallbackBody");
        L2ReadBoxedOperand a = arguments2.get(0);
        L2ReadBoxedOperand b = arguments2.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getInt32()).isBottom() || A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getInt32()).isBottom()) {
            return false;
        }
        L2Generator generator = callSiteHelper.generator();
        L2BasicBlock fallback = generator.createBasicBlock("fall back to boxed logic");
        L2ReadIntOperand intA = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand intB = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallback);
        if (generator.currentlyReachable()) {
            L2SemanticValue semanticTemp = generator.newTemp();
            A_Type[] a_TypeArray = new A_Type[]{A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getInt32()), A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getInt32())};
            A_Type typeGuarantee = typeGuaranteeFunction.invoke(CollectionsKt.listOf(a_TypeArray));
            L2WriteIntOperand tempWriter = generator.intWrite(SetsKt.setOf(new L2SemanticUnboxedInt(semanticTemp)), TypeRestriction.Companion.restrictionForType(typeGuarantee, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
            L2Operand[] l2OperandArray = new L2Operand[]{intA, intB, tempWriter};
            generator.addInstruction(this, l2OperandArray);
            callSiteHelper.useAnswer(generator.readBoxed(semanticTemp));
        }
        if (!((Collection)fallback.predecessorEdges()).isEmpty()) {
            L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
            fallbackBody.invoke(callSiteHelper.translator());
        }
        return true;
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadIntOperand input1 = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand input2 = (L2ReadIntOperand)instruction2.operand(1);
        L2WriteIntOperand output = (L2WriteIntOperand)instruction2.operand(2);
        translator.load(method, (L2Register)input1.register());
        translator.load(method, (L2Register)input2.register());
        int[] $this$forEach$iv = this.jvmOpcodes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int p0 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            method.visitInsn(p0);
        }
        translator.store(method, (L2Register)output.register());
    }

    static {
        int[] nArray = new int[]{126};
        bitwiseAnd = new L2_BIT_LOGIC_OP("and", nArray);
        nArray = new int[]{128};
        bitwiseOr = new L2_BIT_LOGIC_OP("or", nArray);
        nArray = new int[]{130};
        bitwiseXor = new L2_BIT_LOGIC_OP("xor", nArray);
        nArray = new int[]{96};
        wrappedAdd = new L2_BIT_LOGIC_OP("wrappedAdd", nArray);
        nArray = new int[]{100};
        wrappedSubtract = new L2_BIT_LOGIC_OP("wrappedSubtract", nArray);
        nArray = new int[]{104};
        wrappedMultiply = new L2_BIT_LOGIC_OP("wrappedMultiply", nArray);
        nArray = new int[]{108};
        wrappedDivide = new L2_BIT_LOGIC_OP("wrappedDivide", nArray);
        nArray = new int[]{124};
        bitwiseUnsignedShiftRight = new L2_BIT_LOGIC_OP("unsignedShiftRight", nArray);
        nArray = new int[]{122};
        bitwiseSignedShiftRight = new L2_BIT_LOGIC_OP("signedShiftRight", nArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/levelTwo/operation/L2_BIT_LOGIC_OP$Companion;", "", "()V", "bitwiseAnd", "Lavail/interpreter/levelTwo/operation/L2_BIT_LOGIC_OP;", "getBitwiseAnd", "()Lavail/interpreter/levelTwo/operation/L2_BIT_LOGIC_OP;", "bitwiseOr", "getBitwiseOr", "bitwiseSignedShiftRight", "getBitwiseSignedShiftRight", "bitwiseUnsignedShiftRight", "getBitwiseUnsignedShiftRight", "bitwiseXor", "getBitwiseXor", "wrappedAdd", "getWrappedAdd", "wrappedDivide", "getWrappedDivide", "wrappedMultiply", "getWrappedMultiply", "wrappedSubtract", "getWrappedSubtract", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getBitwiseAnd() {
            return bitwiseAnd;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getBitwiseOr() {
            return bitwiseOr;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getBitwiseXor() {
            return bitwiseXor;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getWrappedAdd() {
            return wrappedAdd;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getWrappedSubtract() {
            return wrappedSubtract;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getWrappedMultiply() {
            return wrappedMultiply;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getWrappedDivide() {
            return wrappedDivide;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getBitwiseUnsignedShiftRight() {
            return bitwiseUnsignedShiftRight;
        }

        @NotNull
        public final L2_BIT_LOGIC_OP getBitwiseSignedShiftRight() {
            return bitwiseSignedShiftRight;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

