/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.variables.A_Variable;
import avail.descriptor.variables.VariableDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L1InstructionStepper;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.optimizer.StackReifier;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/levelTwo/operation/L2_PREPARE_NEW_FRAME_FOR_L1;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "prepareMethod", "Lavail/optimizer/jvm/CheckedMethod;", "reificationForInterruptInL1Stat", "Lavail/performance/Statistic;", "prepare", "Lavail/optimizer/StackReifier;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "translateToJVM", "", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "avail"})
public final class L2_PREPARE_NEW_FRAME_FOR_L1
extends L2Operation {
    @NotNull
    public static final L2_PREPARE_NEW_FRAME_FOR_L1 INSTANCE = new L2_PREPARE_NEW_FRAME_FOR_L1();
    @NotNull
    private static final Statistic reificationForInterruptInL1Stat = new Statistic(StatisticReport.REIFICATIONS, "Reification for interrupt in L1 preamble");
    @NotNull
    private static final CheckedMethod prepareMethod;

    private L2_PREPARE_NEW_FRAME_FOR_L1() {
        super(new L2NamedOperandType[0]);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        translator.loadInterpreter(method);
        prepareMethod.generateCall(method);
        method.visitInsn(89);
        method.visitVarInsn(58, translator.reifierLocal());
        Label noReification = new Label();
        method.visitJumpInsn(198, noReification);
        method.visitVarInsn(25, translator.reifierLocal());
        method.visitInsn(176);
        method.visitLabel(noReification);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @Nullable
    public static final StackReifier prepare(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        boolean bl2 = bl = !interpreter.getExitNow();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function function = a_Function;
        A_RawFunction code = function.code();
        int numArgs = A_RawFunction.Companion.numArgs(code);
        int numLocals = A_RawFunction.Companion.getNumLocals(code);
        int numArgsAndLocals = numArgs + numLocals;
        int numSlots = A_RawFunction.Companion.getNumSlots(code);
        L1InstructionStepper stepper = interpreter.levelOneStepper;
        int n = numSlots + 1;
        Object object = new AvailObject[n];
        L1InstructionStepper l1InstructionStepper = stepper;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            object[n2] = n2 == 0 ? NilDescriptor.Companion.getNil() : (n2 <= numArgs ? interpreter.argsBuffer.get(n2 - 1) : (n2 <= numArgsAndLocals ? VariableDescriptor.Companion.newVariableWithOuterType$default(VariableDescriptor.Companion, A_RawFunction.Companion.localTypeAt(code, n2 - numArgs), null, 2, null) : NilDescriptor.Companion.getNil()));
        }
        l1InstructionStepper.setPointers((AvailObject[])object);
        code.setUpInstructionDecoder(stepper.getInstructionDecoder());
        stepper.getInstructionDecoder().pc(1);
        stepper.setStackp(numSlots + 1);
        Primitive primitive2 = code.codePrimitive();
        if (primitive2 != null) {
            int n3 = n = !primitive2.hasFlag(Primitive.Flag.CannotFail) ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            A_BasicObject primitiveFailureValue = interpreter.getLatestResult();
            A_Variable primitiveFailureVariable = stepper.pointerAt(numArgs + 1);
            primitiveFailureVariable.setValue(primitiveFailureValue);
        }
        if (interpreter.isInterruptRequested()) {
            object = stepper.getPointers();
            A_Continuation continuation = ContinuationDescriptor.Companion.createContinuationWithFrame(function, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 1, numSlots + 1, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk(), CollectionsKt.listOf(Arrays.copyOf(object, ((AvailObject[])object).length)), 1);
            interpreter.setReifying(true);
            return new StackReifier(true, reificationForInterruptInL1Stat, new Function0<Unit>(interpreter, continuation){
                final /* synthetic */ Interpreter $interpreter;
                final /* synthetic */ A_Continuation $continuation;
                {
                    this.$interpreter = $interpreter;
                    this.$continuation = $continuation;
                    super(0);
                }

                public final void invoke() {
                    this.$interpreter.returnNow = false;
                    AvailObject availObject = this.$interpreter.getReifiedContinuation();
                    Intrinsics.checkNotNull(availObject);
                    this.$interpreter.setReifiedContinuation(A_Continuation.Companion.replacingCaller(this.$continuation, availObject));
                    AvailObject availObject2 = this.$interpreter.getReifiedContinuation();
                    Intrinsics.checkNotNull(availObject2);
                    this.$interpreter.processInterrupt(availObject2);
                    this.$interpreter.setReifying(false);
                }
            });
        }
        return null;
    }

    static {
        Class[] classArray = new Class[]{Interpreter.class};
        prepareMethod = CheckedMethod.Companion.staticMethod(L2_PREPARE_NEW_FRAME_FOR_L1.class, "prepare", StackReifier.class, classArray);
    }
}

