/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.lexing;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.CommentTokenDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapLexerSlashStarCommentBodyStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerSlashStarCommentBody;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapLexerSlashStarCommentBodyStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapLexerSlashStarCommentBody
extends Primitive {
    @NotNull
    public static final P_BootstrapLexerSlashStarCommentBody INSTANCE = new P_BootstrapLexerSlashStarCommentBody();

    private P_BootstrapLexerSlashStarCommentBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source2 = interpreter.argument(0);
        AvailObject sourcePositionInteger = interpreter.argument(1);
        AvailObject startingLineNumber = interpreter.argument(2);
        int sourceSize = A_Tuple.Companion.getTupleSize(source2);
        int startPosition = A_Number.Companion.getExtractInt(sourcePositionInteger);
        int position = startPosition + 1;
        if (position > sourceSize || A_Tuple.Companion.tupleCodePointAt(source2, position) != 42) {
            return interpreter.primitiveSuccess(SetDescriptor.Companion.getEmptySet());
        }
        ++position;
        int depth = 1;
        while (true) {
            if (position >= sourceSize) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Subsequent '*/' to close this (nestable) block comment", new Object[0]);
            }
            int c = A_Tuple.Companion.tupleCodePointAt(source2, position);
            if (c == 42 && A_Tuple.Companion.tupleCodePointAt(source2, position + 1) == 47) {
                position += 2;
                if (--depth != 0) continue;
                break;
            }
            if (c == 47 && A_Tuple.Companion.tupleCodePointAt(source2, position + 1) == 42) {
                position += 2;
                ++depth;
                continue;
            }
            ++position;
        }
        A_Token token = CommentTokenDescriptor.Companion.newCommentToken(source2.copyStringFromToCanDestroy(startPosition, position - 1, false), startPosition, A_Number.Companion.getExtractInt(startingLineNumber), A_Fiber.Companion.getCurrentLexer(interpreter.fiber()));
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tuple(token)};
        return interpreter.primitiveSuccess(SetDescriptor.Companion.set(a_BasicObjectArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return LexerDescriptor.Companion.lexerBodyFunctionType();
    }

    @Override
    @NotNull
    public P_BootstrapLexerSlashStarCommentBodyStyler bootstrapStyler() {
        return P_BootstrapLexerSlashStarCommentBodyStyler.INSTANCE;
    }
}

