/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.SendPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateSendExpression;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_CreateSendExpression
extends Primitive {
    @NotNull
    public static final P_CreateSendExpression INSTANCE = new P_CreateSendExpression();

    private P_CreateSendExpression() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject messageName = interpreter.argument(0);
        AvailObject argsListPhrase = interpreter.argument(1);
        AvailObject returnType = interpreter.argument(2);
        A_Tuple argExpressions = A_Phrase.Companion.getExpressionsTuple(argsListPhrase);
        int argsCount = A_Tuple.Companion.getTupleSize(argExpressions);
        try {
            A_Bundle bundle = A_Atom.Companion.bundleOrCreate(messageName);
            MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
            if (splitter.getNumberOfArguments() != argsCount) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            }
            if (!splitter.checkListStructure(argsListPhrase)) {
                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING);
            }
            return interpreter.primitiveSuccess(SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.emptyTuple(), bundle, argsListPhrase, returnType));
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e.getErrorCode());
        }
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType(), InstanceMetaDescriptor.Companion.topMeta()), PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        boolean bl2 = bl = argumentTypes.size() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type returnTypeType = argumentTypes.get(2);
        AvailObject returnType = A_Type.Companion.getInstance(returnTypeType);
        return PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.create(returnType);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }
}

