/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.ConcatenatedTupleTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_CONCATENATE_TUPLES;
import avail.optimizer.L1Translator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/tuples/P_ConcatenateTuples;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_ConcatenateTuples
extends Primitive {
    @NotNull
    public static final P_ConcatenateTuples INSTANCE = new P_ConcatenateTuples();

    private P_ConcatenateTuples() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject tuples = interpreter.argument(0);
        return interpreter.primitiveSuccess(A_Tuple.Companion.concatenateTuplesCanDestroy(tuples, true));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(TupleTypeDescriptor.Companion.getMostGeneralTupleType())), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        A_Type innerTupleType;
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tuplesType = argumentTypes.get(0);
        A_Type tuplesSizes = A_Type.Companion.getSizeRange(tuplesType);
        A_Number lowerBound = A_Type.Companion.getLowerBound(tuplesSizes);
        A_Number upperBound = A_Type.Companion.getUpperBound(tuplesSizes);
        if (lowerBound.equals(upperBound)) {
            if (A_Number.Companion.greaterThan(lowerBound, IntegerDescriptor.Companion.fromInt(20))) {
                return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
            }
            boolean bl = A_Number.Companion.isInt(lowerBound);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int bound = A_Number.Companion.getExtractInt(lowerBound);
            if (bound == 0) {
                return InstanceTypeDescriptor.Companion.instanceType(TupleDescriptor.Companion.getEmptyTuple());
            }
            A_Type concatenatedType = A_Type.Companion.typeAtIndex(tuplesType, 1);
            int i = 2;
            if (i <= bound) {
                while (true) {
                    concatenatedType = ConcatenatedTupleTypeDescriptor.Companion.concatenatingAnd(concatenatedType, A_Type.Companion.typeAtIndex(tuplesType, i));
                    if (i == bound) break;
                    ++i;
                }
            }
            return concatenatedType;
        }
        if (A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(tuplesType)) == 0 && A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(innerTupleType = A_Type.Companion.getDefaultType(tuplesType))) == 0) {
            A_Type innerSizes = A_Type.Companion.getSizeRange(innerTupleType);
            A_Number minSize = A_Number.Companion.timesCanDestroy(A_Type.Companion.getLowerBound(tuplesSizes), A_Type.Companion.getLowerBound(innerSizes), false);
            A_Number maxSize = A_Number.Companion.timesCanDestroy(A_Type.Companion.getUpperBound(tuplesSizes), A_Type.Companion.getUpperBound(innerSizes), false);
            A_Type newSizeRange = IntegerRangeTypeDescriptor.Companion.integerRangeType(minSize, true, A_Number.Companion.plusCanDestroy(maxSize, IntegerDescriptor.Companion.getOne(), true), false);
            return TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(newSizeRange, TupleDescriptor.Companion.getEmptyTuple(), A_Type.Companion.getDefaultType(innerTupleType));
        }
        return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        v0 = var7_7 = arguments.size() == 1;
        if (_Assertions.ENABLED && !var7_7) {
            var8_9 = "Assertion failed";
            throw new AssertionError((Object)var8_9);
        }
        tupleOfTuplesReg = arguments.get(0);
        generator = translator.getGenerator();
        tupleOfTuplesType = tupleOfTuplesReg.type();
        range = A_Type.Companion.getSizeRange(tupleOfTuplesType);
        size = A_Type.Companion.getLowerBound(range);
        if (!A_Number.Companion.isInt(size) || !A_Type.Companion.getUpperBound(range).equals(size)) {
            return false;
        }
        sizeInt = A_Number.Companion.getExtractInt(size);
        elementRegs = generator.explodeTupleIfPossible(tupleOfTuplesReg, CollectionsKt.toList(A_Type.Companion.tupleOfTypesFromTo(tupleOfTuplesType, 1, sizeInt)));
        if (elementRegs == null) {
            return false;
        }
        $this$filter$iv = elementRegs;
        $i$f$filter = false;
        var16_19 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (L2ReadBoxedOperand)element$iv$iv;
            $i$a$-filter-P_ConcatenateTuples$tryToGenerateSpecialPrimitiveInvocation$1 = false;
            $this$notNullAnd$iv = it.constantOrNull();
            $i$f$notNullAnd = false;
            if ($this$notNullAnd$iv == null) ** GOTO lbl-1000
            $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u2d1_u24lambda_u2d0 = $this$notNullAnd$iv;
            $i$a$-notNullAnd-P_ConcatenateTuples$tryToGenerateSpecialPrimitiveInvocation$1$1 = false;
            if (A_Tuple.Companion.getTupleSize($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u2d1_u24lambda_u2d0) == 0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            v2 = !v1;
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elementRegs = (List)destination$iv$iv;
        currentTuple = null;
        adjustedSources = new ArrayList<E>();
        for (L2ReadBoxedOperand source : elementRegs) {
            constant = source.restriction().getConstantOrNull();
            if (constant == null) {
                if (currentTuple != null) {
                    adjustedSources.add(translator.getGenerator().boxedConstant(currentTuple));
                }
                adjustedSources.add(source);
                v3 = null;
            } else {
                v3 = currentTuple == null ? (A_Tuple)constant : A_Tuple.Companion.concatenateWith(currentTuple, constant, false);
            }
            currentTuple = v3;
        }
        if (currentTuple != null) {
            adjustedSources.add(translator.getGenerator().boxedConstant(currentTuple));
        }
        switch (adjustedSources.size()) {
            case 0: {
                callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(TupleDescriptor.Companion.getEmptyTuple()));
                break;
            }
            case 1: {
                callSiteHelper.useAnswer((L2ReadBoxedOperand)adjustedSources.get(0));
                break;
            }
            default: {
                guaranteedType = this.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
                writer = translator.getGenerator().boxedWriteTemp(TypeRestriction.Companion.restriction$default(TypeRestriction.Companion, guaranteedType, null, null, null, null, null, null, null, false, false, false, false, 4092, null));
                var19_24 = new L2Operand[]{new L2ReadBoxedVectorOperand(adjustedSources), writer};
                translator.addInstruction(L2_CONCATENATE_TUPLES.INSTANCE, var19_24);
                callSiteHelper.useAnswer(translator.readBoxed(writer));
            }
        }
        return true;
    }
}

