/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.configuration;

import avail.utility.configuration.Configuration;
import avail.utility.configuration.ConfigurationException;
import avail.utility.configuration.Configurator;
import avail.utility.configuration.XMLConfiguratorState;
import avail.utility.configuration.XMLDocumentModel;
import avail.utility.configuration.XMLEventHandler;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*$\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00060\u0005*\u001a\b\u0002\u0010\u0006*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0012\u0004\u0012\u0002H\u00010\bB+\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0002\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\t\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lavail/utility/configuration/XMLConfigurator;", "ConfigurationType", "Lavail/utility/configuration/Configuration;", "ElementType", "", "Lavail/utility/configuration/XMLElement;", "StateType", "Lavail/utility/configuration/XMLConfiguratorState;", "Lavail/utility/configuration/Configurator;", "configuration", "state", "elementClass", "Ljava/lang/Class;", "documentStream", "Ljava/io/InputStream;", "(Lavail/utility/configuration/Configuration;Lavail/utility/configuration/XMLConfiguratorState;Ljava/lang/Class;Ljava/io/InputStream;)V", "getConfiguration", "()Lavail/utility/configuration/Configuration;", "Lavail/utility/configuration/Configuration;", "isConfigured", "", "model", "Lavail/utility/configuration/XMLDocumentModel;", "getState", "()Lavail/utility/configuration/XMLConfiguratorState;", "Lavail/utility/configuration/XMLConfiguratorState;", "updateConfiguration", "", "avail"})
public final class XMLConfigurator<ConfigurationType extends Configuration, ElementType extends Enum<ElementType>, StateType extends XMLConfiguratorState<ConfigurationType, ElementType, StateType>>
implements Configurator<ConfigurationType> {
    @NotNull
    private final ConfigurationType configuration;
    @NotNull
    private final StateType state;
    @NotNull
    private final InputStream documentStream;
    private boolean isConfigured;
    @NotNull
    private final XMLDocumentModel<ConfigurationType, ElementType, StateType> model;

    public XMLConfigurator(@NotNull ConfigurationType configuration, @NotNull StateType state, @NotNull Class<ElementType> elementClass, @NotNull InputStream documentStream) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(elementClass, "elementClass");
        Intrinsics.checkNotNullParameter(documentStream, "documentStream");
        this.configuration = configuration;
        this.state = state;
        this.documentStream = documentStream;
        this.model = new XMLDocumentModel(elementClass);
        ((XMLConfiguratorState)this.state).setModel$avail(this.model);
    }

    @Override
    @NotNull
    public ConfigurationType getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final StateType getState() {
        return this.state;
    }

    @Override
    public void updateConfiguration() throws ConfigurationException {
        if (!this.isConfigured) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.documentStream, (DefaultHandler)new XMLEventHandler<ConfigurationType, ElementType, StateType>(this.model, this.state));
                this.isConfigured = true;
            }
            catch (Exception e) {
                throw new ConfigurationException("configuration error", e);
            }
        }
    }
}

