/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.structures;

import avail.utility.structures.LeftistHeap;
import avail.utility.structures.LeftistHeapKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0018"}, d2={"Lavail/utility/structures/LeftistInternal;", "Value", "", "Lavail/utility/structures/LeftistHeap;", "first", "left", "right", "(Ljava/lang/Comparable;Lavail/utility/structures/LeftistHeap;Lavail/utility/structures/LeftistHeap;)V", "getFirst", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "getLeft", "()Lavail/utility/structures/LeftistHeap;", "getRight", "withoutFirst", "getWithoutFirst", "merge", "another", "with", "newValue", "(Ljava/lang/Comparable;)Lavail/utility/structures/LeftistInternal;", "without", "value", "(Ljava/lang/Comparable;)Lavail/utility/structures/LeftistHeap;", "avail"})
public final class LeftistInternal<Value extends Comparable<? super Value>>
extends LeftistHeap<Value> {
    @NotNull
    private final Value first;
    @NotNull
    private final LeftistHeap<Value> left;
    @NotNull
    private final LeftistHeap<Value> right;

    public LeftistInternal(@NotNull Value first, @NotNull LeftistHeap<Value> left, @NotNull LeftistHeap<Value> right) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        super(right.getRank() + 1, left.getSize() + right.getSize() + 1, null);
        this.first = first;
        this.left = left;
        this.right = right;
    }

    @Override
    @NotNull
    public Value getFirst() {
        return this.first;
    }

    @NotNull
    public final LeftistHeap<Value> getLeft() {
        return this.left;
    }

    @NotNull
    public final LeftistHeap<Value> getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public LeftistHeap<Value> getWithoutFirst() {
        return this.left.merge(this.right);
    }

    @Override
    @NotNull
    public LeftistInternal<Value> with(@NotNull Value newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        return this.merge((LeftistHeap)new LeftistInternal<Value>(newValue, LeftistHeapKt.leftistLeaf(), LeftistHeapKt.leftistLeaf()));
    }

    @Override
    @NotNull
    public LeftistInternal<Value> merge(@NotNull LeftistHeap<Value> another) {
        Intrinsics.checkNotNullParameter(another, "another");
        return !(another instanceof LeftistInternal) ? this : (this.getFirst().compareTo(another.getFirst()) <= 0 ? LeftistHeapKt.access$join(this.getFirst(), this.left, this.right.merge(another)) : LeftistHeapKt.access$join(another.getFirst(), ((LeftistInternal)another).left, this.merge((LeftistHeap)((LeftistInternal)another).right)));
    }

    @Override
    @NotNull
    public LeftistHeap<Value> without(@NotNull Value value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (Intrinsics.areEqual(value, this.getFirst())) {
            return this.left.merge(this.right);
        }
        if (value.compareTo(this.getFirst()) < 0) {
            return this;
        }
        LeftistHeap<Value> leftWithout = this.left.without(value);
        LeftistHeap<Value> rightWithout = this.right.without(value);
        if (Intrinsics.areEqual(leftWithout, this.left) && Intrinsics.areEqual(rightWithout, this.right)) {
            return this;
        }
        return LeftistHeapKt.access$join(this.getFirst(), leftWithout, rightWithout);
    }
}

