/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.representation.AvailObject;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.WritesHiddenVariable;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMTranslator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@WritesHiddenVariable(value={L2Operation.HiddenVariable.CURRENT_ARGUMENTS.class, L2Operation.HiddenVariable.LATEST_RETURN_VALUE.class, L2Operation.HiddenVariable.STACK_REIFIER.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0016H\u0016J<\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J \u0010$\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006%"}, d2={"Lavail/interpreter/levelTwo/operation/L2_INVOKE;", "Lavail/interpreter/levelTwo/operation/L2ControlFlowOperation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "preinvokeMethods", "", "Lavail/optimizer/jvm/CheckedMethod;", "[Lavail/optimizer/jvm/CheckedMethod;", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "generatePushArgumentsAndInvoke", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "argsRegsList", "", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "result", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "onNormalReturn", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "onReification", "translateToJVM", "avail"})
public final class L2_INVOKE
extends L2ControlFlowOperation {
    @NotNull
    public static final L2_INVOKE INSTANCE = new L2_INVOKE();
    @NotNull
    private static final CheckedMethod[] preinvokeMethods;

    private L2_INVOKE() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("called function"), L2OperandType.READ_BOXED_VECTOR.named("arguments"), L2OperandType.WRITE_BOXED.named("result", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("on return", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("on reification", L2NamedOperandType.Purpose.OFF_RAMP)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand function = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand arguments = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand result2 = (L2WriteBoxedOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(result2.registerString());
        builder2.append(" \u2190 ");
        builder2.append(function.registerString());
        builder2.append("(");
        builder2.append(arguments.getElements());
        builder2.append(")");
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder2);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand function = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand arguments = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand result2 = (L2WriteBoxedOperand)instruction2.operand(2);
        L2PcOperand onReturn = (L2PcOperand)instruction2.operand(3);
        L2PcOperand onReification = (L2PcOperand)instruction2.operand(4);
        translator.loadInterpreter(method);
        translator.loadInterpreter(method);
        Interpreter.Companion.getChunkField().generateRead(method);
        translator.loadInterpreter(method);
        translator.load(method, (L2Register)function.register());
        this.generatePushArgumentsAndInvoke(translator, method, arguments.getElements(), result2, onReturn, onReification);
    }

    public final void generatePushArgumentsAndInvoke(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull List<L2ReadBoxedOperand> argsRegsList, @NotNull L2WriteBoxedOperand result2, @NotNull L2PcOperand onNormalReturn, @NotNull L2PcOperand onReification) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(argsRegsList, (String)"argsRegsList");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)onNormalReturn, (String)"onNormalReturn");
        Intrinsics.checkNotNullParameter((Object)onReification, (String)"onReification");
        int numArgs = argsRegsList.size();
        if (numArgs < preinvokeMethods.length) {
            Iterable $this$forEach$iv = argsRegsList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2ReadBoxedOperand it = (L2ReadBoxedOperand)element$iv;
                boolean bl = false;
                translator.load(method, (L2Register)it.register());
            }
            preinvokeMethods[numArgs].generateCall(method);
        } else {
            translator.objectArray(method, argsRegsList, AvailObject.class);
            Interpreter.Companion.getPreinvokeMethod().generateCall(method);
        }
        translator.loadInterpreter(method);
        Interpreter.Companion.getInterpreterRunChunkMethod().generateCall(method);
        Interpreter.Companion.getPostinvokeMethod().generateCall(method);
        method.visitVarInsn(58, translator.reifierLocal());
        method.visitVarInsn(25, translator.reifierLocal());
        Label onReificationPreamble = new Label();
        method.visitJumpInsn(199, onReificationPreamble);
        translator.loadInterpreter(method);
        Interpreter.Companion.getGetLatestResultMethod().generateCall(method);
        translator.store(method, (L2Register)result2.register());
        translator.jump(method, onNormalReturn);
        method.visitLabel(onReificationPreamble);
        translator.generateReificationPreamble(method, onReification);
    }

    static {
        CheckedMethod[] checkedMethodArray = new CheckedMethod[]{Interpreter.Companion.getPreinvoke0Method(), Interpreter.Companion.getPreinvoke1Method(), Interpreter.Companion.getPreinvoke2Method(), Interpreter.Companion.getPreinvoke3Method()};
        preinvokeMethods = checkedMethodArray;
    }
}

