/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.AvailRuntime;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.variables.A_Variable;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.VariableGetException;
import avail.exceptions.VariableSetException;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwoSimple.L2SimpleInstruction;
import avail.optimizer.StackReifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0003H\u0004\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u00a2\u0006\u0002\u0010%J%\u0010&\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010'R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006("}, d2={"Lavail/interpreter/levelTwoSimple/L2Simple_AbstractReifiableInstruction;", "Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;", "stackp", "", "pc", "nextOffset", "liveIndices", "", "(III[Ljava/lang/Integer;)V", "getLiveIndices", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "getNextOffset", "()I", "getPc", "getStackp", "createContinuation", "Lavail/descriptor/functions/A_Continuation;", "caller", "registers", "Lavail/descriptor/representation/AvailObject;", "thisChunk", "Lavail/interpreter/levelTwo/L2Chunk;", "offset", "(Lavail/descriptor/functions/A_Continuation;[Lavail/descriptor/representation/AvailObject;Lavail/interpreter/levelTwo/L2Chunk;I)Lavail/descriptor/functions/A_Continuation;", "handleVariableGetException", "Lavail/optimizer/StackReifier;", "e", "Lavail/exceptions/VariableGetException;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "(Lavail/exceptions/VariableGetException;Lavail/interpreter/execution/Interpreter;[Lavail/descriptor/representation/AvailObject;)Lavail/optimizer/StackReifier;", "handleVariableSetException", "Lavail/exceptions/VariableSetException;", "variable", "Lavail/descriptor/variables/A_Variable;", "value", "(Lavail/exceptions/VariableSetException;Lavail/descriptor/variables/A_Variable;Lavail/descriptor/representation/AvailObject;Lavail/interpreter/execution/Interpreter;[Lavail/descriptor/representation/AvailObject;)Lavail/optimizer/StackReifier;", "reenter", "([Lavail/descriptor/representation/AvailObject;Lavail/interpreter/execution/Interpreter;)Lavail/optimizer/StackReifier;", "avail"})
public abstract class L2Simple_AbstractReifiableInstruction
extends L2SimpleInstruction {
    private final int stackp;
    private final int pc;
    private final int nextOffset;
    @NotNull
    private final Integer[] liveIndices;

    public L2Simple_AbstractReifiableInstruction(int stackp, int pc, int nextOffset, @NotNull Integer[] liveIndices) {
        Intrinsics.checkNotNullParameter((Object)liveIndices, (String)"liveIndices");
        super(null);
        this.stackp = stackp;
        this.pc = pc;
        this.nextOffset = nextOffset;
        this.liveIndices = liveIndices;
    }

    public final int getStackp() {
        return this.stackp;
    }

    public final int getPc() {
        return this.pc;
    }

    public final int getNextOffset() {
        return this.nextOffset;
    }

    @NotNull
    public final Integer[] getLiveIndices() {
        return this.liveIndices;
    }

    @Override
    @Nullable
    public StackReifier reenter(@NotNull AvailObject[] registers, @NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        if (!interpreter.checkValidity(L2JVMChunk.ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk())) {
            return null;
        }
        boolean bl2 = bl = !interpreter.returnNow && !interpreter.getExitNow();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject availObject = interpreter.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        AvailObject con = availObject;
        int n = registers.length;
        for (int i = 1; i < n; ++i) {
            registers[i] = A_Continuation.Companion.frameAt(con, i);
        }
        interpreter.popContinuation();
        return null;
    }

    @NotNull
    protected final A_Continuation createContinuation(@NotNull A_Continuation caller, @NotNull AvailObject[] registers, @NotNull L2Chunk thisChunk, int offset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter((Object)thisChunk, (String)"thisChunk");
        boolean bl2 = bl = registers.length - 1 == this.liveIndices.length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject continuation = ContinuationDescriptor.Companion.createContinuationExceptFrame(registers[0], caller, NilDescriptor.Companion.getNil(), this.pc, this.stackp, thisChunk, offset);
        int i = 1;
        int n = this.liveIndices.length;
        if (i <= n) {
            while (true) {
                int index2 = this.liveIndices[i - 1];
                A_Continuation.Companion.frameAtPut(continuation, i, index2 == 0 ? NilDescriptor.Companion.getNil() : registers[index2]);
                if (i == n) break;
                ++i;
            }
        }
        return continuation;
    }

    public static /* synthetic */ A_Continuation createContinuation$default(L2Simple_AbstractReifiableInstruction l2Simple_AbstractReifiableInstruction, A_Continuation a_Continuation, AvailObject[] availObjectArray, L2Chunk l2Chunk, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createContinuation");
        }
        if ((n2 & 8) != 0) {
            n = l2Simple_AbstractReifiableInstruction.nextOffset;
        }
        return l2Simple_AbstractReifiableInstruction.createContinuation(a_Continuation, availObjectArray, l2Chunk, n);
    }

    @NotNull
    public final StackReifier handleVariableGetException(@NotNull VariableGetException e, @NotNull Interpreter interpreter, @NotNull AvailObject[] registers) {
        StackReifier reifier;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        boolean bl = e.getNumericCode().equals(AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE.numericCode());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Chunk l2Chunk = interpreter.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        L2Chunk thisChunk = l2Chunk;
        A_Function unassignedVariableFunction = interpreter.runtime.get(AvailRuntime.HookType.READ_UNASSIGNED_VARIABLE);
        List<AvailObject> args = interpreter.argsBuffer;
        args.clear();
        StackReifier stackReifier = reifier = interpreter.invokeFunction(unassignedVariableFunction);
        Intrinsics.checkNotNull((Object)stackReifier);
        if (stackReifier.actuallyReify()) {
            reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(registers, this, thisChunk){
                final /* synthetic */ AvailObject[] $registers;
                final /* synthetic */ L2Simple_AbstractReifiableInstruction this$0;
                final /* synthetic */ L2Chunk $thisChunk;
                {
                    this.$registers = $registers;
                    this.this$0 = $receiver;
                    this.$thisChunk = $thisChunk;
                    super(1);
                }

                public final void invoke(@NotNull Interpreter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.this$0.getStackp();
                    A_Type a_Type = BottomTypeDescriptor.Companion.getBottom();
                    Intrinsics.checkNotNull((Object)a_Type, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                    this.$registers[n] = (AvailObject)a_Type;
                    AvailObject availObject = it.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    A_Continuation continuation = L2Simple_AbstractReifiableInstruction.createContinuation$default(this.this$0, availObject, this.$registers, this.$thisChunk, 0, 8, null);
                    it.setReifiedContinuation(continuation);
                }
            }));
        }
        return reifier;
    }

    @Nullable
    public final StackReifier handleVariableSetException(@NotNull VariableSetException e, @NotNull A_Variable variable, @NotNull AvailObject value, @NotNull Interpreter interpreter, @NotNull AvailObject[] registers) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        boolean bl = e.getNumericCode().equals(AvailErrorCode.E_OBSERVED_VARIABLE_WRITTEN_WHILE_UNTRACED.numericCode());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Chunk l2Chunk = interpreter.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        L2Chunk thisChunk = l2Chunk;
        List<AvailObject> args = interpreter.argsBuffer;
        args.clear();
        List<AvailObject> list2 = interpreter.argsBuffer;
        A_Function a_Function = Interpreter.Companion.assignmentFunction();
        Intrinsics.checkNotNull((Object)a_Function, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        list2.add((AvailObject)a_Function);
        List<AvailObject> list3 = interpreter.argsBuffer;
        A_Tuple a_Tuple = ObjectTupleDescriptor.Companion.tuple(variable, value);
        Intrinsics.checkNotNull((Object)a_Tuple, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        list3.add((AvailObject)a_Tuple);
        StackReifier reifier = interpreter.invokeFunction(interpreter.runtime.get(AvailRuntime.HookType.IMPLICIT_OBSERVE));
        if (reifier != null && reifier.actuallyReify()) {
            reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(registers, this, thisChunk){
                final /* synthetic */ AvailObject[] $registers;
                final /* synthetic */ L2Simple_AbstractReifiableInstruction this$0;
                final /* synthetic */ L2Chunk $thisChunk;
                {
                    this.$registers = $registers;
                    this.this$0 = $receiver;
                    this.$thisChunk = $thisChunk;
                    super(1);
                }

                public final void invoke(@NotNull Interpreter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$registers[this.this$0.getStackp()] = PrimitiveTypeDescriptor.Types.TOP.getO();
                    AvailObject availObject = it.getReifiedContinuation();
                    Intrinsics.checkNotNull((Object)availObject);
                    A_Continuation continuation = L2Simple_AbstractReifiableInstruction.createContinuation$default(this.this$0, availObject, this.$registers, this.$thisChunk, 0, 8, null);
                    it.setReifiedContinuation(continuation);
                }
            }));
        }
        return reifier;
    }
}

