/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.structures;

import avail.descriptor.numbers.IntegerDescriptor;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0000J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/utility/structures/BloomFilter;", "", "bitCount", "", "hashCount", "(II)V", "existingFilter", "(Lavail/utility/structures/BloomFilter;)V", "array", "", "add", "", "element", "addAll", "filter", "computeHash", "hashIndex", "get", "", "setBit", "hash", "testBit", "avail"})
public final class BloomFilter {
    private final int hashCount;
    @NotNull
    private final long[] array;

    public BloomFilter(int bitCount, int hashCount) {
        this.hashCount = hashCount;
        this.array = new long[bitCount + 63 >> 6];
    }

    public BloomFilter(@NotNull BloomFilter existingFilter) {
        Intrinsics.checkNotNullParameter((Object)existingFilter, (String)"existingFilter");
        this.hashCount = existingFilter.hashCount;
        this.array = (long[])existingFilter.array.clone();
    }

    public final void add(int element) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, this.hashCount);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            this.setBit(this.computeHash(element, it));
        }
    }

    public final boolean get(int element) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)new IntRange(1, this.hashCount);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (this.testBit(this.computeHash(element, it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final int computeHash(int element, int hashIndex) {
        return IntegerDescriptor.Companion.computeHashOfLong(((long)element << 32) + (long)hashIndex);
    }

    private final void setBit(int hash) {
        int index2 = (hash >>> 6) % this.array.length;
        long mask = 1L << (hash & 0x3F);
        this.array[index2] = this.array[index2] | mask;
    }

    private final boolean testBit(int hash) {
        int index2 = (hash >>> 6) % this.array.length;
        long mask = 1L << (hash & 0x3F);
        return (this.array[index2] & mask) != 0L;
    }

    public final void addAll(@NotNull BloomFilter filter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        boolean bl2 = bl = this.array.length == filter.array.length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.hashCount == filter.hashCount;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            this.array[i] = this.array[i] | filter.array[i];
        }
    }
}

