/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.builder.ModuleName;
import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_ModuleHeaderPrefixCheckModuleName;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_ModuleHeaderPrefixCheckModuleName
extends Primitive {
    @NotNull
    public static final P_ModuleHeaderPrefixCheckModuleName INSTANCE = new P_ModuleHeaderPrefixCheckModuleName();

    private P_ModuleHeaderPrefixCheckModuleName() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Private, Primitive.Flag.Bootstrap};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject moduleNameLiteral = interpreter.argument(0);
        AvailLoader loader = interpreter.availLoader();
        A_Module module = loader.getModule();
        A_String qualifiedName2 = A_Module.Companion.getModuleName(module);
        ModuleName moduleNameInstance = new ModuleName(qualifiedName2.asNativeString(), false, 2, null);
        String localName2 = moduleNameInstance.getLocalName();
        String declaredModuleName = A_Phrase.Companion.getToken(moduleNameLiteral).literal().literal().asNativeString();
        if (!Intrinsics.areEqual(localName2, declaredModuleName)) {
            Object[] objectArray = new Object[]{declaredModuleName, localName2};
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "module name (%s) to agree with file's name (%s)", objectArray);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{PhraseTypeDescriptor.Constants.INSTANCE.getStringLiteralType()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

