/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MethodDefinitionException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_BundleHasDefinitionForArgumentTypes;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BundleHasDefinitionForArgumentTypes
extends Primitive {
    @NotNull
    public static final P_BundleHasDefinitionForArgumentTypes INSTANCE = new P_BundleHasDefinitionForArgumentTypes();

    private P_BundleHasDefinitionForArgumentTypes() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Atom a_Atom;
        Interpreter interpreter2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject methodName = interpreter.argument(0);
        AvailObject argTypes2 = interpreter.argument(1);
        A_Bundle bundle = A_Atom.Companion.getBundleOrNil(methodName);
        if (bundle.isNil()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_METHOD);
        }
        A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
        if (A_Tuple.Companion.getTupleSize(argTypes2) != A_Method.Companion.getNumArgs(method)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        Interpreter interpreter3 = interpreter;
        try {
            interpreter2 = interpreter3;
            A_Definition definition = A_Method.Companion.lookupByTypesFromTuple(method, argTypes2);
            boolean bl = definition.getNotNil();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            a_Atom = AtomDescriptor.Companion.getTrueObject();
        }
        catch (MethodDefinitionException methodDefinitionException) {
            interpreter2 = interpreter3;
            a_Atom = AtomDescriptor.Companion.getFalseObject();
        }
        return interpreter2.primitiveSuccess(a_Atom);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.zeroOrMoreOf(InstanceMetaDescriptor.Companion.anyMeta())), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_AMBIGUOUS_METHOD_DEFINITION, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_NO_METHOD, AvailErrorCode.E_NO_METHOD_DEFINITION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

