/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import com.sun.nio.file.ExtendedWatchEventModifier;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.PathUtils;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    private final Logger logger;
    private final WatchService watchService;
    private final Map<Path, Path> registeredPathToRootPath = new HashMap<Path, Path>();
    private final boolean isMac;
    private final DirectoryChangeListener listener;
    private final SortedMap<Path, FileHash> pathHashes;
    private final Set<Path> directories;
    private final Map<WatchKey, Path> keyRoots;
    private Boolean fileTreeSupported = null;
    private FileHasher fileHasher;
    private volatile boolean closed = false;

    public static Builder builder() {
        return new Builder();
    }

    public DirectoryWatcher(List<Path> list2, DirectoryChangeListener directoryChangeListener, WatchService watchService, FileHasher fileHasher, Logger logger) throws IOException {
        this.listener = directoryChangeListener;
        this.watchService = watchService;
        this.isMac = watchService instanceof MacOSXListeningWatchService;
        this.pathHashes = new ConcurrentSkipListMap<Path, FileHash>();
        this.directories = Collections.newSetFromMap(new ConcurrentHashMap());
        this.keyRoots = new ConcurrentHashMap<WatchKey, Path>();
        this.fileHasher = fileHasher;
        this.logger = logger;
        PathUtils.initWatcherState(list2, fileHasher, this.pathHashes, this.directories);
        for (Path path : list2) {
            this.registerAll(path, path);
        }
    }

    public CompletableFuture<Void> watchAsync() {
        return this.watchAsync(ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> watchAsync(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            this.watch();
            return null;
        }, executor);
    }

    public Map<Path, FileHash> pathHashes() {
        return Collections.unmodifiableMap(this.pathHashes);
    }

    public void watch() {
        while (this.listener.isWatching()) {
            WatchKey watchKey;
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                try {
                    WatchEvent.Kind<?> kind2 = watchEvent.kind();
                    WatchEvent watchEvent2 = PathUtils.cast(watchEvent);
                    int n = watchEvent2.count();
                    Path path = (Path)watchEvent2.context();
                    if (!this.keyRoots.containsKey(watchKey)) {
                        throw new IllegalStateException("WatchService returned key [" + watchKey + "] but it was not found in keyRoots!");
                    }
                    Path path3 = this.keyRoots.get(watchKey);
                    Path path4 = this.registeredPathToRootPath.get(path3);
                    Path path5 = path == null ? null : this.keyRoots.get(watchKey).resolve(path);
                    this.logger.debug("{} [{}]", (Object)kind2, (Object)path5);
                    if (kind2 == StandardWatchEventKinds.OVERFLOW) {
                        this.onEvent(DirectoryChangeEvent.EventType.OVERFLOW, false, path5, n, path4);
                        continue;
                    }
                    if (path == null) {
                        throw new IllegalStateException("WatchService returned a null path for " + kind2.name());
                    }
                    if (kind2 == StandardWatchEventKinds.ENTRY_CREATE) {
                        boolean bl = Files.isDirectory(path5, LinkOption.NOFOLLOW_LINKS);
                        if (bl) {
                            if (!Boolean.TRUE.equals(this.fileTreeSupported)) {
                                this.registerAll(path5, path4);
                            }
                            if (!this.isMac) {
                                PathUtils.recursiveVisitFiles(path5, path2 -> this.notifyCreateEvent(true, path2, n, path4), path2 -> this.notifyCreateEvent(false, path2, n, path4));
                            }
                        }
                        this.notifyCreateEvent(bl, path5, n, path4);
                        continue;
                    }
                    if (kind2 == StandardWatchEventKinds.ENTRY_MODIFY) {
                        boolean set2 = this.directories.contains(path5);
                        if (this.fileHasher == null) {
                            this.onEvent(DirectoryChangeEvent.EventType.MODIFY, set2, path5, n, path4);
                            continue;
                        }
                        FileHash fileHash = (FileHash)this.pathHashes.get(path5);
                        FileHash fileHash2 = PathUtils.hash(this.fileHasher, path5);
                        if (fileHash2 != null && !fileHash2.equals(fileHash)) {
                            this.pathHashes.put(path5, fileHash2);
                            this.onEvent(DirectoryChangeEvent.EventType.MODIFY, set2, path5, n, path4);
                            continue;
                        }
                        if (fileHash2 != null) continue;
                        this.logger.debug("Failed to hash modified file [{}]. It may have been deleted.", (Object)path5);
                        continue;
                    }
                    if (kind2 != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    if (this.fileHasher == null) {
                        boolean bl = this.directories.remove(path5);
                        this.onEvent(DirectoryChangeEvent.EventType.DELETE, bl, path5, n, path4);
                        continue;
                    }
                    Set<Path> set2 = PathUtils.subMap(this.pathHashes, path5).keySet();
                    for (Path path6 : set2) {
                        boolean bl = this.directories.remove(path6);
                        this.onEvent(DirectoryChangeEvent.EventType.DELETE, bl, path6, n, path4);
                    }
                    set2.clear();
                }
                catch (Exception exception) {
                    this.logger.debug("DirectoryWatcher got an exception while watching!", exception);
                    this.listener.onException(exception);
                }
            }
            boolean bl = watchKey.reset();
            if (bl) continue;
            this.logger.debug("WatchKey for [{}] no longer valid; removing.", (Object)watchKey.watchable());
            Path path = this.keyRoots.remove(watchKey);
            this.registeredPathToRootPath.remove(path);
            if (!this.keyRoots.isEmpty()) continue;
            this.logger.debug("No more directories left to watch; terminating watcher.");
            break;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void onEvent(DirectoryChangeEvent.EventType eventType, boolean bl, Path path, int n, Path path2) throws IOException {
        this.logger.debug("-> {} [{}] (isDirectory: {})", new Object[]{eventType, path, bl});
        FileHash fileHash = (FileHash)this.pathHashes.get(path);
        this.listener.onEvent(new DirectoryChangeEvent(eventType, bl, path, fileHash, n, path2));
    }

    public DirectoryChangeListener getListener() {
        return this.listener;
    }

    public void close() throws IOException {
        this.watchService.close();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void registerAll(Path path3, Path path4) throws IOException {
        if (!Boolean.FALSE.equals(this.fileTreeSupported)) {
            try {
                this.register(path3, true, path4);
                this.fileTreeSupported = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logger.debug("Assuming ExtendedWatchEventModifier.FILE_TREE is not supported", unsupportedOperationException);
                this.fileTreeSupported = false;
                this.registerAll(path3, path4);
            }
        } else {
            PathUtils.recursiveVisitFiles(path3, path2 -> this.register(path2, false, path4), path -> {});
        }
    }

    private void register(Path path, boolean bl, Path path2) throws IOException {
        WatchEvent.Modifier[] modifierArray;
        Watchable watchable;
        this.logger.debug("Registering [{}].", (Object)path);
        Watchable watchable2 = watchable = this.isMac ? new WatchablePath(path) : path;
        if (bl) {
            WatchEvent.Modifier[] modifierArray2 = new WatchEvent.Modifier[1];
            modifierArray = modifierArray2;
            modifierArray2[0] = ExtendedWatchEventModifier.FILE_TREE;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifierArray3 = modifierArray;
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WatchKey watchKey = watchable.register(this.watchService, kindArray, modifierArray3);
        this.keyRoots.put(watchKey, path);
        this.registeredPathToRootPath.put(path, path2);
    }

    private void notifyCreateEvent(boolean bl, Path path, int n, Path path2) throws IOException {
        if (this.fileHasher != null) {
            FileHash fileHash = PathUtils.hash(this.fileHasher, path);
            if (fileHash == null) {
                if (Files.notExists(path, new LinkOption[0])) {
                    this.logger.debug("Failed to hash created file [{}]. It may have been deleted.", (Object)path);
                    return;
                }
                this.logger.debug("Failed to hash created file [{}]. It may be locked.", (Object)path);
            } else if (this.pathHashes.put(path, fileHash) != null) {
                this.logger.debug("Skipping create event for path [{}]. Path already hashed.", (Object)path);
                return;
            }
        }
        if (bl) {
            this.directories.add(path);
        }
        this.onEvent(DirectoryChangeEvent.EventType.CREATE, bl, path, n, path2);
    }

    public static final class Builder {
        private List<Path> paths = Collections.emptyList();
        private DirectoryChangeListener listener = directoryChangeEvent -> {};
        private Logger logger = null;
        private FileHasher fileHasher = FileHasher.DEFAULT_FILE_HASHER;
        private WatchService watchService = null;

        private Builder() {
        }

        public Builder paths(List<Path> list2) {
            this.paths = list2;
            return this;
        }

        public Builder path(Path path) {
            return this.paths(Collections.singletonList(path));
        }

        public Builder listener(DirectoryChangeListener directoryChangeListener) {
            this.listener = directoryChangeListener;
            return this;
        }

        public Builder watchService(WatchService watchService) {
            this.watchService = watchService;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder fileHashing(boolean bl) {
            this.fileHasher = bl ? FileHasher.DEFAULT_FILE_HASHER : null;
            return this;
        }

        public Builder fileHasher(FileHasher fileHasher) {
            this.fileHasher = fileHasher;
            return this;
        }

        public DirectoryWatcher build() throws IOException {
            if (this.watchService == null) {
                this.osDefaultWatchService();
            }
            if (this.logger == null) {
                this.staticLogger();
            }
            return new DirectoryWatcher(this.paths, this.listener, this.watchService, this.fileHasher, this.logger);
        }

        private Builder osDefaultWatchService() throws IOException {
            boolean bl = System.getProperty("os.name").toLowerCase().contains("mac");
            if (bl) {
                return this.watchService(new MacOSXListeningWatchService(new MacOSXListeningWatchService.Config(){

                    @Override
                    public FileHasher fileHasher() {
                        return null;
                    }
                }));
            }
            return this.watchService(FileSystems.getDefault().newWatchService());
        }

        private Builder staticLogger() {
            return this.logger(LoggerFactory.getLogger(DirectoryWatcher.class));
        }
    }
}

