/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.jar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.availlang.artifact.ArtifactDescriptor;
import org.availlang.artifact.AvailArtifact;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.AvailRootFileMetadata;
import org.availlang.artifact.DigestUtility;
import org.availlang.artifact.ResourceType;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.json.JSONObject;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u0019H\u0016J\u000e\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0019J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010!\u001a\u00020\u0019H\u0016J6\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010!\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020 0\u001fJ\b\u0010)\u001a\u00020\u0013H\u0016J\u0016\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019J\b\u0010+\u001a\u0004\u0018\u00010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/availlang/artifact/jar/AvailArtifactJar;", "Lorg/availlang/artifact/AvailArtifact;", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "artifactDescriptor", "Lorg/availlang/artifact/ArtifactDescriptor;", "getArtifactDescriptor", "()Lorg/availlang/artifact/ArtifactDescriptor;", "jarFile", "Ljava/util/jar/JarFile;", "jarFileEntries", "Ljava/util/Enumeration;", "Ljava/util/jar/JarEntry;", "getJarFileEntries$annotations", "()V", "getJarFileEntries", "()Ljava/util/Enumeration;", "manifest", "Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "getManifest", "()Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "manifest$delegate", "Lkotlin/Lazy;", "name", "", "getName", "()Ljava/lang/String;", "close", "", "extractDigestForRoot", "", "", "rootName", "extractFile", "filePath", "extractFileMetadataForRoot", "", "Lorg/availlang/artifact/AvailRootFileMetadata;", "entries", "digests", "extractManifest", "extractRootFile", "getImplementationVersion", "Companion", "avail-artifact"})
public final class AvailArtifactJar
implements AvailArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI uri;
    @NotNull
    private final JarFile jarFile;
    @NotNull
    private final ArtifactDescriptor artifactDescriptor;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy manifest$delegate;
    public static final int CURRENT_ARTIFACT_VERSION = 1;

    public AvailArtifactJar(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        this.uri = uri;
        this.manifest$delegate = LazyKt.lazy((Function0)new Function0<AvailArtifactManifest>(this){
            final /* synthetic */ AvailArtifactJar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AvailArtifactManifest invoke() {
                return this.this$0.extractManifest();
            }
        });
        try {
            this.jarFile = new JarFile(this.uri.getPath());
            String string2 = this.jarFile.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "jarFile.name");
            this.name = string2;
            this.artifactDescriptor = ArtifactDescriptor.Companion.from(this.extractFile("avail-artifact-contents/artifact-descriptor"));
        }
        catch (Throwable e) {
            throw new AvailArtifactException("Problem accessing Avail Artifact Jar File: " + this.uri + ".", e);
        }
    }

    @Override
    @NotNull
    public ArtifactDescriptor getArtifactDescriptor() {
        return this.artifactDescriptor;
    }

    @NotNull
    public final Enumeration<JarEntry> getJarFileEntries() {
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, "jarFile.entries()");
        return enumeration;
    }

    public static /* synthetic */ void getJarFileEntries$annotations() {
    }

    @Nullable
    public final String getImplementationVersion() {
        Object object = this.jarFile.getManifest().getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION);
        return object instanceof String ? (String)object : null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public AvailArtifactManifest getManifest() {
        Lazy lazy = this.manifest$delegate;
        return (AvailArtifactManifest)lazy.getValue();
    }

    public final void close() {
        this.jarFile.close();
    }

    @NotNull
    public final byte[] extractFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        ZipEntry zipEntry = this.jarFile.getEntry(filePath);
        if (zipEntry == null) {
            throw new AvailArtifactException("Could not locate " + filePath + " in the JAR file " + this.uri);
        }
        ZipEntry digestEntry = zipEntry;
        byte[] bytes = new byte[(int)digestEntry.getSize()];
        DataInputStream stream = new DataInputStream(new BufferedInputStream(this.jarFile.getInputStream(digestEntry), 4096));
        stream.readFully(bytes);
        return bytes;
    }

    @NotNull
    public final byte[] extractRootFile(@NotNull String rootName, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return this.extractFile("avail-artifact-contents/" + rootName + "/Avail-Sources/" + filePath);
    }

    @Override
    @NotNull
    public AvailArtifactManifest extractManifest() {
        JSONObject jSONObject;
        byte[] rawManifest = this.extractFile("avail-artifact-contents/avail-artifact-manifest.txt");
        String text = new String(rawManifest, Charsets.UTF_8);
        try {
            jSONObject = UtilityKt.jsonObject$default(text, null, 2, null);
        }
        catch (Throwable e) {
            throw new AvailArtifactException("Failure in parsing Avail Manifest, avail-artifact-contents/avail-artifact-manifest.txt in the JAR file " + this.uri, e);
        }
        JSONObject json = jSONObject;
        return AvailArtifactManifest.Companion.from(json);
    }

    @Override
    @NotNull
    public Map<String, byte[]> extractDigestForRoot(@NotNull String rootName) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        String digestPath = AvailArtifact.Companion.rootArtifactDigestFilePath(rootName);
        ZipEntry zipEntry = this.jarFile.getEntry(digestPath);
        if (zipEntry == null) {
            throw new AvailArtifactException("Could not locate digest, " + digestPath + ", for root, " + rootName);
        }
        ZipEntry digestEntry = zipEntry;
        byte[] bytes = new byte[(int)digestEntry.getSize()];
        DataInputStream stream = new DataInputStream(new BufferedInputStream(this.jarFile.getInputStream(digestEntry), 4096));
        stream.readFully(bytes);
        return DigestUtility.INSTANCE.parseDigest(new String(bytes, Charsets.UTF_8));
    }

    @Override
    @NotNull
    public List<AvailRootFileMetadata> extractFileMetadataForRoot(@NotNull String rootName) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        Map<String, byte[]> digests = this.extractDigestForRoot(rootName);
        Enumeration<JarEntry> entries2 = this.jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(entries2, "entries");
        return this.extractFileMetadataForRoot(rootName, entries2, digests);
    }

    @NotNull
    public final List<AvailRootFileMetadata> extractFileMetadataForRoot(@NotNull String rootName, @NotNull Enumeration<JarEntry> entries2, @NotNull Map<String, byte[]> digests) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        Intrinsics.checkNotNullParameter(entries2, "entries");
        Intrinsics.checkNotNullParameter(digests, "digests");
        Object object = this.getManifest().getRoots().get(rootName);
        if (object == null || (object = ((AvailRootManifest)object).getAvailModuleExtensions()) == null) {
            object = CollectionsKt.listOf(".avail");
        }
        List<String> extensions = object;
        String prefix = "avail-artifact-contents/" + rootName + "/Avail-Sources/";
        List metadata2 = new ArrayList();
        Iterator<JarEntry> iterator2 = CollectionsKt.iterator(entries2);
        while (iterator2.hasNext()) {
            ResourceType resourceType;
            String it;
            boolean bl;
            boolean $i$f$any;
            Iterable $this$any$iv;
            String entryName;
            JarEntry entry;
            block18: {
                entry = iterator2.next();
                String string2 = entryName = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "entryName");
                if (!StringsKt.startsWith$default(string2, prefix, false, 2, null)) continue;
                String string3 = entryName;
                Intrinsics.checkNotNullExpressionValue(string3, "entryName");
                entryName = StringsKt.removePrefix(string3, (CharSequence)prefix);
                $this$any$iv = extensions;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl2 = false;
                        String string4 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue(string4, "entry.name");
                        if (!StringsKt.endsWith$default(string4, it + "/", false, 2, null)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                resourceType = ResourceType.PACKAGE;
            } else {
                String string5 = entryName;
                Intrinsics.checkNotNullExpressionValue(string5, "entryName");
                if (StringsKt.endsWith$default(string5, "/", false, 2, null)) {
                    resourceType = ResourceType.DIRECTORY;
                } else {
                    boolean bl3;
                    block19: {
                        $this$any$iv = extensions;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl4 = false;
                                String string6 = entry.getName();
                                Intrinsics.checkNotNullExpressionValue(string6, "entry.name");
                                if (!StringsKt.endsWith$default(string6, it, false, 2, null)) continue;
                                bl3 = true;
                                break block19;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        boolean $this$any$iv2;
                        boolean bl5 = $this$any$iv2 = !entry.isDirectory();
                        if (_Assertions.ENABLED && !$this$any$iv2) {
                            String $i$f$any2 = "Assertion failed";
                            throw new AssertionError((Object)$i$f$any2);
                        }
                        String string7 = entryName;
                        Intrinsics.checkNotNullExpressionValue(string7, "entryName");
                        String[] $i$f$any2 = new String[]{"/"};
                        List parts = StringsKt.split$default((CharSequence)string7, $i$f$any2, false, 0, 6, null);
                        resourceType = parts.size() >= 2 && Intrinsics.areEqual(CollectionsKt.last(parts), parts.get(parts.size() - 2)) ? ResourceType.REPRESENTATIVE : ResourceType.MODULE;
                    } else {
                        resourceType = ResourceType.RESOURCE;
                    }
                }
            }
            ResourceType type2 = resourceType;
            String string8 = entryName;
            Intrinsics.checkNotNullExpressionValue(string8, "entryName");
            String string9 = entryName = StringsKt.removeSuffix(string8, (CharSequence)"/");
            Intrinsics.checkNotNullExpressionValue(string9, "entryName");
            String[] $i$f$any2 = new String[]{"/"};
            String qualifiedName2 = CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)string9, $i$f$any2, false, 0, 6, null), "/", "/" + rootName + "/", null, 0, null, extractFileMetadataForRoot.qualifiedName.1.INSTANCE, 28, null);
            String mimeType = switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1, 2 -> "text/plain";
                default -> "";
            };
            String string10 = entryName;
            Intrinsics.checkNotNullExpressionValue(string10, "entryName");
            metadata2.add(new AvailRootFileMetadata(string10, type2, qualifiedName2, mimeType, entry.getLastModifiedTime().toMillis(), entry.getSize(), digests.get(entryName)));
        }
        return metadata2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/availlang/artifact/jar/AvailArtifactJar$Companion;", "", "()V", "CURRENT_ARTIFACT_VERSION", "", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.MODULE.ordinal()] = 1;
            nArray[ResourceType.REPRESENTATIVE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

