/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.WritesHiddenVariable;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.interpreter.levelTwo.operation.L2_INVOKE;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@WritesHiddenVariable(value={L2Operation.HiddenVariable.CURRENT_FUNCTION.class, L2Operation.HiddenVariable.CURRENT_ARGUMENTS.class, L2Operation.HiddenVariable.LATEST_RETURN_VALUE.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lavail/interpreter/levelTwo/operation/L2_INVOKE_CONSTANT_FUNCTION;", "Lavail/interpreter/levelTwo/operation/L2ControlFlowOperation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_INVOKE_CONSTANT_FUNCTION
extends L2ControlFlowOperation {
    @NotNull
    public static final L2_INVOKE_CONSTANT_FUNCTION INSTANCE = new L2_INVOKE_CONSTANT_FUNCTION();

    private L2_INVOKE_CONSTANT_FUNCTION() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.CONSTANT.named("constant function"), L2OperandType.READ_BOXED_VECTOR.named("arguments"), L2OperandType.WRITE_BOXED.named("result", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("on return", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("on reification", L2NamedOperandType.Purpose.OFF_RAMP)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ConstantOperand constantFunction = (L2ConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand arguments = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand result2 = (L2WriteBoxedOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(result2.registerString());
        builder2.append(" \u2190 ");
        builder2.append(constantFunction.getConstant());
        builder2.append("(");
        builder2.append(arguments.getElements());
        builder2.append(")");
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder2);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ConstantOperand constantFunction = (L2ConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand arguments = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand result2 = (L2WriteBoxedOperand)instruction2.operand(2);
        L2PcOperand onReturn = (L2PcOperand)instruction2.operand(3);
        L2PcOperand onReification = (L2PcOperand)instruction2.operand(4);
        translator.loadInterpreter(method);
        translator.loadInterpreter(method);
        Interpreter.Companion.getChunkField().generateRead(method);
        translator.loadInterpreter(method);
        translator.literal(method, constantFunction.getConstant());
        L2_INVOKE.INSTANCE.generatePushArgumentsAndInvoke(translator, method, arguments.getElements(), result2, onReturn, onReification);
    }
}

