/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapDefinitionStyler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/methods/P_MethodDeclarationFromAtom;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefinitionStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_MethodDeclarationFromAtom
extends Primitive {
    @NotNull
    public static final P_MethodDeclarationFromAtom INSTANCE = new P_MethodDeclarationFromAtom();

    private P_MethodDeclarationFromAtom() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        A_Atom atom = interpreter.argument(0);
        A_Function function = interpreter.argument(1);
        A_Tuple optionalStylerFunction = interpreter.argument(2);
        A_Fiber fiber2 = interpreter.fiber();
        AvailLoader loader = A_Fiber.Companion.getAvailLoader(fiber2);
        if (loader == null || loader.getModule().isNil()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        return interpreter.suspendInSafePointThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)((Function1)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(loader, atom, function, optionalStylerFunction){
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ A_Atom $atom;
            final /* synthetic */ A_Function $function;
            final /* synthetic */ A_Tuple $optionalStylerFunction;
            {
                this.$loader = $loader;
                this.$atom = $atom;
                this.$function = $function;
                this.$optionalStylerFunction = $optionalStylerFunction;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendInSafePointThen) {
                Intrinsics.checkNotNullParameter($this$suspendInSafePointThen, (String)"$this$suspendInSafePointThen");
                try {
                    this.$loader.addMethodBody(this.$atom, this.$function);
                    A_String atomName = A_Atom.Companion.getAtomName(this.$atom);
                    A_RawFunction code = this.$function.code();
                    A_RawFunction.Companion.setMethodName(code, StringDescriptor.Companion.stringFrom(atomName.toString()));
                    if (A_Tuple.Companion.getTupleSize(this.$optionalStylerFunction) == 1) {
                        AvailObject stylerFunction = A_Tuple.Companion.tupleAt(this.$optionalStylerFunction, 1);
                        this.$loader.addStyler(A_Atom.Companion.bundleOrCreate(this.$atom), stylerFunction);
                    } else {
                        AvailLoader.Companion.addBootstrapStyler(code, this.$atom, this.$loader.getModule());
                    }
                    $this$suspendInSafePointThen.succeed(NilDescriptor.Companion.getNil());
                }
                catch (AvailException e) {
                    $this$suspendInSafePointThen.fail(e.getErrorCode());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), TupleTypeDescriptor.Companion.zeroOrOneOf(A_Styler.Companion.getStylerFunctionType())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_METHOD_RETURN_TYPE_NOT_AS_FORWARD_DECLARED, AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES, AvailErrorCode.E_RESULT_TYPE_SHOULD_COVARY_WITH_ARGUMENTS, AvailErrorCode.E_METHOD_IS_SEALED, AvailErrorCode.E_STYLER_ALREADY_SET_BY_THIS_MODULE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    @Override
    @NotNull
    public P_BootstrapDefinitionStyler bootstrapStyler() {
        return P_BootstrapDefinitionStyler.INSTANCE;
    }
}

