/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TokenTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateToken;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_CreateToken
extends Primitive {
    @NotNull
    public static final P_CreateToken INSTANCE = new P_CreateToken();

    private P_CreateToken() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(4);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject type = list2.get(0);
        AvailObject lexeme = list2.get(1);
        AvailObject start = list2.get(2);
        AvailObject line = list2.get(3);
        if (!A_Number.Companion.isInt(start) || !A_Number.Companion.isInt(line) || (long)A_Number.Companion.getExtractInt(line) >= 0x10000000L) {
            return interpreter.primitiveFailure(AvailErrorCode.E_EXCEEDS_VM_LIMIT);
        }
        return interpreter.primitiveSuccess(TokenDescriptor.Companion.newToken(lexeme, A_Number.Companion.getExtractInt(start), A_Number.Companion.getExtractInt(line), TokenDescriptor.TokenType.Companion.lookupTokenType(A_Number.Companion.getExtractInt(A_Atom.Companion.getAtomProperty(type, TokenDescriptor.StaticInit.INSTANCE.getTokenTypeOrdinalKey()))), A_Fiber.Companion.getCurrentLexer(interpreter.fiber())));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type atomType = argumentTypes.get(0);
        if (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(atomType), 1)) {
            AvailObject atom = A_Type.Companion.getInstance(atomType);
            return TokenTypeDescriptor.Companion.tokenType(TokenDescriptor.TokenType.Companion.lookupTokenType(A_Number.Companion.getExtractInt(A_Atom.Companion.getAtomProperty(atom, TokenDescriptor.StaticInit.INSTANCE.getTokenTypeOrdinalKey()))));
        }
        return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{TokenDescriptor.TokenType.END_OF_FILE.getAtom(), TokenDescriptor.TokenType.KEYWORD.getAtom(), TokenDescriptor.TokenType.OPERATOR.getAtom(), TokenDescriptor.TokenType.COMMENT.getAtom(), TokenDescriptor.TokenType.WHITESPACE.getAtom()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(a_BasicObjectArray)), TupleTypeDescriptor.Companion.getStringType(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), PrimitiveTypeDescriptor.Types.TOKEN.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_EXCEEDS_VM_LIMIT};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

