/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.files.FileManager;
import avail.resolver.FileSystemModuleRootResolverFactory;
import avail.resolver.JarModuleRootResolverFactory;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ModuleRootResolverFactory;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/resolver/ModuleRootResolverRegistry;", "", "()V", "resolvers", "", "", "Lavail/resolver/ModuleRootResolverFactory;", "createResolver", "Lavail/resolver/ModuleRootResolver;", "name", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "register", "", "factory", "avail"})
public final class ModuleRootResolverRegistry {
    @NotNull
    public static final ModuleRootResolverRegistry INSTANCE = new ModuleRootResolverRegistry();
    @NotNull
    private static final Map<String, ModuleRootResolverFactory> resolvers = new LinkedHashMap();

    private ModuleRootResolverRegistry() {
    }

    public final void register(@NotNull ModuleRootResolverFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (resolvers.keySet().contains(factory.getScheme())) {
            throw new IllegalStateException("Attempted to add a ModuleRootResolverFactory, " + factory + ", but already present");
        }
        String string2 = factory.getScheme().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        resolvers.put(string2, factory);
    }

    @NotNull
    public final ModuleRootResolver createResolver(@NotNull String name2, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        URI lookup = uri.getScheme() == null ? new URI("file:///" + uri) : uri;
        ModuleRootResolverFactory factory = resolvers.get(lookup.getScheme());
        if (factory == null) {
            throw new UnsupportedOperationException("URI scheme, " + uri.getScheme() + ", does not have a registered ModuleRootResolverFactory.");
        }
        return factory.resolver(name2, lookup, fileManager);
    }

    static {
        INSTANCE.register(FileSystemModuleRootResolverFactory.INSTANCE);
        INSTANCE.register(JarModuleRootResolverFactory.INSTANCE);
    }
}

