/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import avail.anvil.streams.StreamStyle;
import avail.builder.ModuleRoot;
import avail.builder.ResolvedModuleName;
import avail.persistence.cache.Repository;
import java.awt.event.ActionEvent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lavail/anvil/actions/CleanModuleAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "avail"})
public final class CleanModuleAction
extends AbstractWorkbenchAction {
    public CleanModuleAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        super(workbench, "Clean Module", null, null, 12, null);
        this.putValue("ShortDescription", "Invalidate cached compilations for a module/package.");
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter(event, "event");
        boolean bl2 = bl = this.getWorkbench().getBackgroundTask() == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ModuleRoot root = this.getWorkbench().selectedModuleRoot();
        if (root != null) {
            try {
                root.clearRepository();
            }
            catch (IndexedFileException indexedFileException) {
                // empty catch block
            }
            AvailWorkbench availWorkbench = this.getWorkbench();
            Object[] objectArray = new Object[]{root.getName()};
            String string3 = String.format("Repository %s has been cleaned.%n", objectArray);
            Intrinsics.checkNotNullExpressionValue(string3, "format(\"Repository %s ha\u2026n cleaned.%n\", root.name)");
            availWorkbench.writeText(string3, StreamStyle.INFO);
            return;
        }
        ResolvedModuleName resolvedModuleName = this.getWorkbench().selectedModule();
        Intrinsics.checkNotNull(resolvedModuleName);
        ResolvedModuleName selectedModule = resolvedModuleName;
        String rootRelative = selectedModule.getRootRelativeName();
        Repository repository = selectedModule.getRepository();
        repository.cleanModulesUnder(rootRelative);
        repository.commit();
        AvailWorkbench availWorkbench = this.getWorkbench();
        Object[] objectArray = new Object[]{selectedModule.getQualifiedName()};
        String string4 = String.format("Module or package %s has been cleaned.%n", objectArray);
        Intrinsics.checkNotNullExpressionValue(string4, "format(\n\t\t\t\t\"Module or p\u2026ctedModule.qualifiedName)");
        availWorkbench.writeText(string4, StreamStyle.INFO);
    }
}

