/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lavail/anvil/actions/SetDocumentationPathAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "avail"})
public final class SetDocumentationPathAction
extends AbstractWorkbenchAction {
    public SetDocumentationPathAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        super(workbench, "Set Documentation Path\u2026", null, null, 12, null);
        this.putValue("ShortDescription", "Set the Stacks documentation path.");
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(this.getWorkbench().getDocumentationPath().toFile());
        chooser.ensureFileIsVisible(this.getWorkbench().getDocumentationPath().toFile());
        chooser.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Directories";
            }

            public boolean accept(@Nullable File f) {
                boolean bl;
                boolean bl2 = bl = f != null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                File file2 = f;
                Intrinsics.checkNotNull(file2);
                return file2.isDirectory() && f.canWrite();
            }
        });
        int result2 = chooser.showDialog(this.getWorkbench(), "Set Documentation Path");
        if (result2 == 0) {
            AvailWorkbench availWorkbench = this.getWorkbench();
            Path path = chooser.getSelectedFile().toPath();
            Intrinsics.checkNotNullExpressionValue(path, "chooser.selectedFile.toPath()");
            availWorkbench.setDocumentationPath(path);
        }
    }
}

