/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.controlflow;

import avail.AvailRuntime;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MapException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.TextInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/controlflow/P_ExceptionStackDump;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_ExceptionStackDump
extends Primitive {
    @NotNull
    public static final P_ExceptionStackDump INSTANCE = new P_ExceptionStackDump();

    private P_ExceptionStackDump() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Continuation a_Continuation;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject exception = interpreter.argument(0);
        AvailRuntime runtime = interpreter.runtime;
        try {
            a_Continuation = exception.fieldAt(ObjectTypeDescriptor.Companion.Exceptions.INSTANCE.getStackDumpAtom());
        }
        catch (MapException e) {
            boolean bl;
            boolean bl2 = bl = A_Number.Companion.getExtractInt(e.getNumericCode()) == AvailErrorCode.E_KEY_NOT_FOUND.nativeCode();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
        }
        A_Continuation continuation = a_Continuation;
        TextInterface textInterface = A_Fiber.Companion.getTextInterface(interpreter.fiber());
        return interpreter.suspendThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(runtime, textInterface, continuation){
            final /* synthetic */ AvailRuntime $runtime;
            final /* synthetic */ TextInterface $textInterface;
            final /* synthetic */ A_Continuation $continuation;
            {
                this.$runtime = $runtime;
                this.$textInterface = $textInterface;
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendThen) {
                Intrinsics.checkNotNullParameter($this$suspendThen, "$this$suspendThen");
                ContinuationDescriptor.Companion.dumpStackThen(this.$runtime, this.$textInterface, this.$continuation, (Function1<? super List<String>, Unit>)new Function1<List<? extends String>, Unit>($this$suspendThen){
                    final /* synthetic */ Interpreter.SuspensionHelper<A_BasicObject> $this_suspendThen;
                    {
                        this.$this_suspendThen = $this_suspendThen;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull List<String> stack) {
                        Collection<A_String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter(stack, "stack");
                        Iterable iterable = RangesKt.reversed(CollectionsKt.getIndices((Collection)stack));
                        ObjectTupleDescriptor.Companion companion = ObjectTupleDescriptor.Companion;
                        Interpreter.SuspensionHelper<A_BasicObject> suspensionHelper = this.$this_suspendThen;
                        boolean $i$f$map = false;
                        void var4_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void it;
                            int item$iv$iv;
                            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(StringDescriptor.Companion.stringFrom(stack.get((int)it)));
                        }
                        collection = (List)destination$iv$iv;
                        suspensionHelper.succeed(companion.tupleFromList(collection));
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ObjectTypeDescriptor.Companion.Exceptions.INSTANCE.getExceptionType()), TupleTypeDescriptor.Companion.zeroOrMoreOf(TupleTypeDescriptor.Companion.getStringType()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

