/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.ThreadSafe;
import avail.descriptor.character.A_Character;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.serialization.SerializerOperation;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB3\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H&J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006 "}, d2={"Lavail/descriptor/tuples/StringDescriptor;", "Lavail/descriptor/tuples/TupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "objectSlotsEnumClass", "Ljava/lang/Class;", "Lavail/descriptor/representation/ObjectSlotsEnum;", "integerSlotsEnumClass", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Lavail/descriptor/representation/Mutability;Ljava/lang/Class;Ljava/lang/Class;)V", "o_IsString", "", "self", "Lavail/descriptor/representation/AvailObject;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_TupleCodePointAt", "", "index", "o_TupleElementsInRangeAreInstancesOf", "startIndex", "endIndex", "type", "Lavail/descriptor/types/A_Type;", "o_TupleIntAt", "o_TupleLongAt", "", "o_WriteTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail"})
public abstract class StringDescriptor
extends TupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected StringDescriptor(@NotNull Mutability mutability, @Nullable Class<? extends ObjectSlotsEnum> objectSlotsEnumClass, @Nullable Class<? extends IntegerSlotsEnum> integerSlotsEnumClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        super(mutability, objectSlotsEnumClass, integerSlotsEnumClass);
    }

    @Override
    public boolean o_IsString(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int size = A_Tuple.Companion.getTupleSize(self);
        int i = 1;
        if (i <= size) {
            while (true) {
                int codePoint;
                if ((codePoint = A_Tuple.Companion.tupleCodePointAt(self, i)) >= 256) {
                    return SerializerOperation.SHORT_STRING;
                }
                if (i == size) break;
                ++i;
            }
        }
        return SerializerOperation.BYTE_STRING;
    }

    @Override
    public abstract int o_TupleCodePointAt(@NotNull AvailObject var1, int var2);

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return A_Type.Companion.isSubtypeOf(PrimitiveTypeDescriptor.Types.CHARACTER.getO(), type) || super.o_TupleElementsInRangeAreInstancesOf(self, startIndex, endIndex, type);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        this.unsupportedOperation();
        throw new KotlinNothingValueException();
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        this.unsupportedOperation();
        throw new KotlinNothingValueException();
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(self.asNativeString());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b\"\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lavail/descriptor/tuples/StringDescriptor$Companion;", "", "()V", "formatString", "Lavail/descriptor/tuples/A_String;", "pattern", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lavail/descriptor/tuples/A_String;", "generateStringFromCodePoints", "size", "", "generator", "Lkotlin/Function1;", "stringFrom", "aNativeString", "stringWithSurrogatesFrom", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_String stringWithSurrogatesFrom(@NotNull String aNativeString) {
            Intrinsics.checkNotNullParameter((Object)aNativeString, (String)"aNativeString");
            int charCount = aNativeString.length();
            if (charCount == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            int maxChar = 0;
            for (int index2 = 0; index2 < charCount; ++index2) {
                char aChar = aNativeString.charAt(index2);
                maxChar = RangesKt.coerceAtLeast((int)maxChar, (int)aChar);
            }
            return maxChar <= 255 ? (A_String)ByteStringDescriptor.Companion.mutableObjectFromNativeByteString(aNativeString) : (A_String)TwoByteStringDescriptor.Companion.generateTwoByteString(aNativeString.length(), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(aNativeString){
                final /* synthetic */ String $aNativeString;
                {
                    this.$aNativeString = $aNativeString;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$aNativeString.charAt(it - 1);
                }
            }));
        }

        @NotNull
        public final A_String stringFrom(@NotNull String aNativeString) {
            int codePoint;
            Intrinsics.checkNotNullParameter((Object)aNativeString, (String)"aNativeString");
            int charCount = aNativeString.length();
            if (charCount == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            int maxCodePoint = 0;
            int count = 0;
            for (int index2 = 0; index2 < charCount; index2 += Character.charCount(codePoint)) {
                codePoint = aNativeString.codePointAt(index2);
                maxCodePoint = Math.max(maxCodePoint, codePoint);
                ++count;
            }
            if (maxCodePoint <= 255) {
                return ByteStringDescriptor.Companion.mutableObjectFromNativeByteString(aNativeString);
            }
            if (maxCodePoint <= 65535) {
                return TwoByteStringDescriptor.Companion.mutableObjectFromNativeTwoByteString(aNativeString);
            }
            Ref.IntRef charIndex = new Ref.IntRef();
            return ObjectTupleDescriptor.Companion.generateObjectTupleFrom(count, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(aNativeString, charIndex){
                final /* synthetic */ String $aNativeString;
                final /* synthetic */ Ref.IntRef $charIndex;
                {
                    this.$aNativeString = $aNativeString;
                    this.$charIndex = $charIndex;
                    super(1);
                }

                @NotNull
                public final A_BasicObject invoke(int it) {
                    int codePoint = this.$aNativeString.codePointAt(this.$charIndex.element);
                    this.$charIndex.element += Character.charCount(codePoint);
                    return CharacterDescriptor.Companion.fromCodePoint(codePoint);
                }
            }));
        }

        @NotNull
        public final A_String generateStringFromCodePoints(int size, @NotNull Function1<? super Integer, Integer> generator) {
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            Ref.ObjectRef string2 = new Ref.ObjectRef();
            string2.element = ByteStringDescriptor.Companion.createUninitializedByteString(size);
            int representationLimit = 255;
            int i = 1;
            if (i <= size) {
                while (true) {
                    int codePoint = ((Number)generator.invoke((Object)i)).intValue();
                    A_Character character = CharacterDescriptor.Companion.fromCodePoint(codePoint);
                    if (codePoint > representationLimit) {
                        if (codePoint <= 65535) {
                            string2.element = TwoByteStringDescriptor.Companion.generateTwoByteString(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>((Ref.ObjectRef<A_Tuple>)string2){
                                final /* synthetic */ Ref.ObjectRef<A_Tuple> $string;
                                {
                                    this.$string = $string;
                                    super(1);
                                }

                                @NotNull
                                public final Integer invoke(int it) {
                                    return A_Tuple.Companion.tupleCodePointAt((A_Tuple)this.$string.element, it);
                                }
                            }));
                            representationLimit = 65535;
                        } else {
                            boolean bl;
                            boolean bl2 = bl = codePoint <= 0x10FFFF;
                            if (_Assertions.ENABLED && !bl) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                            string2.element = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(size, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>((Ref.ObjectRef<A_Tuple>)string2){
                                final /* synthetic */ Ref.ObjectRef<A_Tuple> $string;
                                {
                                    this.$string = $string;
                                    super(1);
                                }

                                @NotNull
                                public final A_BasicObject invoke(int it) {
                                    return A_Tuple.Companion.tupleAt((A_Tuple)this.$string.element, it);
                                }
                            }));
                            representationLimit = 0x10FFFF;
                        }
                    }
                    string2.element = A_Tuple.Companion.tupleAtPuttingCanDestroy((A_Tuple)string2.element, i, character, true);
                    if (i == size) break;
                    ++i;
                }
            }
            Object object = string2.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type avail.descriptor.tuples.A_String");
            return (A_String)object;
        }

        @NotNull
        public final A_String formatString(@NotNull String pattern, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string2 = String.format(pattern, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return this.stringFrom(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

