/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AbstractFileWrapper;
import avail.files.AvailBinaryFile;
import avail.files.AvailFile;
import avail.files.AvailModuleFile;
import avail.files.AvailTextFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.resolver.ResolverReference;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.availlang.artifact.ResourceType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ:\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00100\u00122\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lavail/files/NullFileWrapper;", "Lavail/files/AbstractFileWrapper;", "raw", "", "resolverReference", "Lavail/resolver/ResolverReference;", "fileManager", "Lavail/files/FileManager;", "([BLavail/resolver/ResolverReference;Lavail/files/FileManager;)V", "file", "Lavail/files/AvailFile;", "getFile", "()Lavail/files/AvailFile;", "file$delegate", "Lkotlin/Lazy;", "delete", "", "success", "Lkotlin/Function1;", "Ljava/util/UUID;", "failure", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "Companion", "avail"})
public final class NullFileWrapper
extends AbstractFileWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy file$delegate;
    private static final UUID nullUUID;

    public NullFileWrapper(@NotNull byte[] raw, @NotNull ResolverReference resolverReference, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)resolverReference, (String)"resolverReference");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        UUID uUID = nullUUID;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"nullUUID");
        super(uUID, resolverReference, fileManager);
        this.file$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AvailFile>(resolverReference, this, raw){
            final /* synthetic */ ResolverReference $resolverReference;
            final /* synthetic */ NullFileWrapper this$0;
            final /* synthetic */ byte[] $raw;
            {
                this.$resolverReference = $resolverReference;
                this.this$0 = $receiver;
                this.$raw = $raw;
                super(0);
            }

            @NotNull
            public final AvailFile invoke() {
                return this.$resolverReference.getType() == ResourceType.MODULE || this.$resolverReference.getType() == ResourceType.REPRESENTATIVE || Intrinsics.areEqual((Object)this.$resolverReference.getMimeType(), (Object)"text/avail") ? (AvailFile)new AvailModuleFile(this.this$0, null, 2, null) : (AvailFile.Companion.isTextFile(this.$resolverReference.getMimeType()) ? (AvailFile)new AvailTextFile(this.$raw, this.this$0, null, 4, null) : (AvailFile)new AvailBinaryFile(this.this$0));
            }
        }));
    }

    @Override
    @NotNull
    public AvailFile getFile() {
        Lazy lazy = this.file$delegate;
        return (AvailFile)lazy.getValue();
    }

    @Override
    public void delete(@NotNull Function1<? super UUID, Unit> success2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failure) {
        Intrinsics.checkNotNullParameter(success2, (String)"success");
        Intrinsics.checkNotNullParameter(failure, (String)"failure");
        if (!Files.deleteIfExists(Paths.get(this.getReference().getUri()))) {
            failure.invoke((Object)FileErrorCode.FILE_NOT_FOUND, null);
        } else {
            success2.invoke((Object)this.getId());
        }
    }

    static {
        String string2 = "Null UUID";
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        nullUUID = UUID.nameUUIDFromBytes(byArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lavail/files/NullFileWrapper$Companion;", "", "()V", "nullUUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

