/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapDefinitionStyler;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/methods/P_SimpleMacroDefinitionForAtom;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefinitionStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_SimpleMacroDefinitionForAtom
extends Primitive {
    @NotNull
    public static final P_SimpleMacroDefinitionForAtom INSTANCE = new P_SimpleMacroDefinitionForAtom();

    private P_SimpleMacroDefinitionForAtom() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject atom = interpreter.argument(0);
        AvailObject prefixFunctions = interpreter.argument(1);
        AvailObject function = interpreter.argument(2);
        A_Tuple optionalStylerFunction = interpreter.argument(3);
        A_Fiber fiber2 = interpreter.fiber();
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        Iterable $this$forEach$iv = prefixFunctions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject prefixFunction = (AvailObject)element$iv;
            boolean bl = false;
            int numArgs = A_RawFunction.Companion.numArgs(prefixFunction.code());
            A_Type kind2 = prefixFunction.kind();
            A_Type argsKind = A_Type.Companion.getArgsTupleType(kind2);
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(1, numArgs);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int argIndex = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                if (A_Type.Companion.isSubtypeOf(A_Type.Companion.typeAtIndex(argsKind, argIndex), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())) continue;
                return interpreter.primitiveFailure(AvailErrorCode.E_MACRO_PREFIX_FUNCTION_ARGUMENT_MUST_BE_A_PHRASE);
            }
            if (A_Type.Companion.getReturnType(kind2).isTop()) continue;
            return interpreter.primitiveFailure(AvailErrorCode.E_MACRO_PREFIX_FUNCTIONS_MUST_RETURN_TOP);
        }
        try {
            MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(A_Atom.Companion.bundleOrCreate(atom));
            if (A_Tuple.Companion.getTupleSize(prefixFunctions) != splitter.getNumberOfSectionCheckpoints()) {
                return interpreter.primitiveFailure(AvailErrorCode.E_MACRO_PREFIX_FUNCTION_INDEX_OUT_OF_BOUNDS);
            }
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e.getErrorCode());
        }
        int numArgs = A_RawFunction.Companion.numArgs(function.code());
        A_Type kind3 = function.kind();
        A_Type argsKind = A_Type.Companion.getArgsTupleType(kind3);
        int argIndex = 1;
        if (argIndex <= numArgs) {
            while (true) {
                if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.typeAtIndex(argsKind, argIndex), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())) {
                    return interpreter.primitiveFailure(AvailErrorCode.E_MACRO_ARGUMENT_MUST_BE_A_PHRASE);
                }
                if (argIndex == numArgs) break;
                ++argIndex;
            }
        }
        if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(kind3), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_MACRO_MUST_RETURN_A_PHRASE);
        }
        return interpreter.suspendInSafePointThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)((Function1)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(loader, atom, function, prefixFunctions, optionalStylerFunction){
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ AvailObject $atom;
            final /* synthetic */ AvailObject $function;
            final /* synthetic */ AvailObject $prefixFunctions;
            final /* synthetic */ A_Tuple $optionalStylerFunction;
            {
                this.$loader = $loader;
                this.$atom = $atom;
                this.$function = $function;
                this.$prefixFunctions = $prefixFunctions;
                this.$optionalStylerFunction = $optionalStylerFunction;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendInSafePointThen) {
                Intrinsics.checkNotNullParameter($this$suspendInSafePointThen, (String)"$this$suspendInSafePointThen");
                try {
                    this.$loader.addMacroBody(this.$atom, this.$function, this.$prefixFunctions, false);
                    A_String atomName = A_Atom.Companion.getAtomName(this.$atom);
                    if (A_Tuple.Companion.getTupleSize(this.$optionalStylerFunction) == 1) {
                        AvailObject stylerFunction = A_Tuple.Companion.tupleAt(this.$optionalStylerFunction, 1);
                        this.$loader.addStyler(A_Atom.Companion.bundleOrCreate(this.$atom), stylerFunction);
                    }
                    AvailLoader.Companion.addBootstrapStyler(this.$function.code(), this.$atom, this.$loader.getModule());
                    Iterable $this$forEachIndexed$iv = this.$prefixFunctions;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void prefixFunction;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        AvailObject availObject = (AvailObject)item$iv;
                        int zeroIndex = n;
                        boolean bl = false;
                        A_RawFunction.Companion.setMethodName(prefixFunction.code(), StringDescriptor.Companion.stringFrom("Macro prefix #" + (zeroIndex + 1) + " of " + atomName));
                    }
                    A_RawFunction.Companion.setMethodName(this.$function.code(), StringDescriptor.Companion.stringFrom("Macro body of " + atomName));
                    $this$suspendInSafePointThen.succeed(NilDescriptor.Companion.getNil());
                }
                catch (AvailException e) {
                    $this$suspendInSafePointThen.fail(e.getErrorCode());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.zeroOrMoreOf(FunctionTypeDescriptor.Companion.mostGeneralFunctionType()), FunctionTypeDescriptor.Companion.functionTypeReturning(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType()), TupleTypeDescriptor.Companion.zeroOrOneOf(A_Styler.Companion.getStylerFunctionType())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES, AvailErrorCode.E_MACRO_PREFIX_FUNCTION_ARGUMENT_MUST_BE_A_PHRASE, AvailErrorCode.E_MACRO_PREFIX_FUNCTIONS_MUST_RETURN_TOP, AvailErrorCode.E_MACRO_ARGUMENT_MUST_BE_A_PHRASE, AvailErrorCode.E_MACRO_MUST_RETURN_A_PHRASE, AvailErrorCode.E_MACRO_PREFIX_FUNCTION_INDEX_OUT_OF_BOUNDS, AvailErrorCode.E_STYLER_ALREADY_SET_BY_THIS_MODULE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    @Override
    @NotNull
    public P_BootstrapDefinitionStyler bootstrapStyler() {
        return P_BootstrapDefinitionStyler.INSTANCE;
    }
}

