/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sockets;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousServerSocketChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/sockets/P_ServerSocketIPv6Bind;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_ServerSocketIPv6Bind
extends Primitive {
    @NotNull
    public static final P_ServerSocketIPv6Bind INSTANCE = new P_ServerSocketIPv6Bind();

    private P_ServerSocketIPv6Bind() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject handle2 = interpreter.argument(0);
        AvailObject addressTuple = interpreter.argument(1);
        AvailObject port = interpreter.argument(2);
        AvailObject backlog = interpreter.argument(3);
        AvailObject pojo = A_Atom.Companion.getAtomProperty(handle2, AtomDescriptor.SpecialAtom.SERVER_SOCKET_KEY.getAtom());
        if (pojo.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(handle2) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        AsynchronousServerSocketChannel socket = (AsynchronousServerSocketChannel)pojo.javaObjectNotNull();
        int n = 0;
        Object object = new byte[16];
        while (n < 16) {
            int n2 = n++;
            object[n2] = (byte)A_Tuple.Companion.tupleIntAt(addressTuple, n2 + 1);
        }
        byte[] addressBytes = object;
        int backlogInt = A_Number.Companion.getExtractInt(backlog);
        try {
            InetAddress $this$cast$iv = Inet6Address.getByAddress(addressBytes);
            boolean $i$f$cast = false;
            Inet6Address inetAddress = (Inet6Address)$this$cast$iv;
            InetSocketAddress address = new InetSocketAddress(inetAddress, A_Number.Companion.getExtractUnsignedShort(port));
            socket.bind(address, backlogInt);
            object = (Object)interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        catch (IllegalStateException e) {
            object = (Object)interpreter.primitiveFailure(AvailErrorCode.E_INVALID_HANDLE);
        }
        catch (UnknownHostException e) {
            if (_Assertions.ENABLED) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            object = (Object)interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        catch (IOException e) {
            object = (Object)interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        catch (SecurityException e) {
            object = (Object)interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        return object;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(16), TupleDescriptor.Companion.getEmptyTuple(), IntegerRangeTypeDescriptor.Companion.getBytes()), IntegerRangeTypeDescriptor.Companion.getUnsignedShorts(), PojoTypeDescriptor.Companion.intRange()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_IO_ERROR, AvailErrorCode.E_PERMISSION_DENIED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

