/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.jvm;

import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u001a\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\u0007\"\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/optimizer/jvm/CheckedConstructor;", "", "verifyAnnotation", "", "receiverClass", "Ljava/lang/Class;", "argumentTypes", "", "(ZLjava/lang/Class;[Ljava/lang/Class;)V", "methodDescriptorString", "", "methodNameString", "receiverClassInternalName", "generateCall", "", "methodVisitor", "Lorg/objectweb/asm/MethodVisitor;", "Companion", "avail"})
public final class CheckedConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String methodNameString;
    @NotNull
    private final String receiverClassInternalName;
    @NotNull
    private final String methodDescriptorString;

    private CheckedConstructor(boolean verifyAnnotation, Class<?> receiverClass, Class<?> ... argumentTypes) {
        int modifiers;
        boolean bl;
        Object object;
        this.methodNameString = "<init>";
        try {
            Constructor<?> constructor = receiverClass.getConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"{\n\t\t\t\treceiverClass.getC\u2026ctor(*argumentTypes)\n\t\t\t}");
            object = constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        Constructor<?> constructor = object;
        if (verifyAnnotation) {
            ReferencedInGeneratedCode referencedInGeneratedCode = constructor.getAnnotation(ReferencedInGeneratedCode.class);
            if (referencedInGeneratedCode == null) {
                throw new IllegalStateException("Constructor should have had ReferencedInGeneratedCode annotation".toString());
            }
            object = referencedInGeneratedCode;
        }
        boolean bl2 = bl = ((modifiers = constructor.getModifiers()) & 1) != 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = Type.getInternalName(constructor.getDeclaringClass());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInternalName(constructor.declaringClass)");
        this.receiverClassInternalName = string3;
        String string4 = Type.getConstructorDescriptor(constructor);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getConstructorDescriptor(constructor)");
        this.methodDescriptorString = string4;
    }

    public final void generateCall(@NotNull MethodVisitor methodVisitor) {
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        methodVisitor.visitMethodInsn(183, this.receiverClassInternalName, this.methodNameString, this.methodDescriptorString, false);
    }

    public /* synthetic */ CheckedConstructor(boolean verifyAnnotation, Class receiverClass, Class[] argumentTypes, DefaultConstructorMarker $constructor_marker) {
        this(verifyAnnotation, receiverClass, argumentTypes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\tJ3\u0010\n\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/jvm/CheckedConstructor$Companion;", "", "()V", "constructorMethod", "Lavail/optimizer/jvm/CheckedConstructor;", "receiverClass", "Ljava/lang/Class;", "argumentTypes", "", "(Ljava/lang/Class;[Ljava/lang/Class;)Lavail/optimizer/jvm/CheckedConstructor;", "javaLibraryConstructorMethod", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedConstructor constructorMethod(@NotNull Class<?> receiverClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
            return new CheckedConstructor(true, (Class)receiverClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        @NotNull
        public final CheckedConstructor javaLibraryConstructorMethod(@NotNull Class<?> receiverClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, (String)"receiverClass");
            Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
            return new CheckedConstructor(false, (Class)receiverClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

