/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import avail.io.SimpleCompletionHandler;
import avail.utility.Mutable;
import avail.utility.evaluation.Combinator;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/files/P_FileWrite;", "Lavail/interpreter/Primitive;", "()V", "MAX_WRITE_BUFFER_SIZE", "", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileWrite
extends Primitive {
    @NotNull
    public static final P_FileWrite INSTANCE = new P_FileWrite();
    public static final int MAX_WRITE_BUFFER_SIZE = 0x400000;

    private P_FileWrite() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Iterator iterator2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(6);
        AvailObject positionObject = interpreter.argument(0);
        AvailObject bytes = interpreter.argument(1);
        AvailObject atom = interpreter.argument(2);
        AvailObject succeed2 = interpreter.argument(3);
        AvailObject fail2 = interpreter.argument(4);
        AvailObject priority = interpreter.argument(5);
        AvailObject pojo = A_Atom.Companion.getAtomProperty(atom, AtomDescriptor.SpecialAtom.FILE_KEY.getAtom());
        if (pojo.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(atom) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        IOSystem.FileHandle handle2 = (IOSystem.FileHandle)pojo.javaObjectNotNull();
        if (!handle2.getCanWrite()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NOT_OPEN_FOR_WRITE);
        }
        AsynchronousFileChannel fileChannel = handle2.getChannel();
        if (!A_Number.Companion.isLong(positionObject)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_EXCEEDS_VM_LIMIT);
        }
        int alignment = handle2.getAlignment();
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        IOSystem ioSystem = runtime.getIoSystem();
        long oneBasedPositionLong = A_Number.Companion.getExtractLong(positionObject);
        boolean bl2 = bl = oneBasedPositionLong > 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), runtime, A_Fiber.Companion.getTextInterface(current), A_Number.Companion.getExtractInt(priority), null, (Function0)new Function0<A_String>(handle2){
            final /* synthetic */ IOSystem.FileHandle $handle;
            {
                this.$handle = $handle;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                return StringDescriptor.Companion.stringFrom("Asynchronous file write, " + this.$handle.getFilename());
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        int totalBytes = A_Tuple.Companion.getTupleSize(bytes);
        if (bytes.isByteBufferTuple()) {
            buffer = A_Tuple.Companion.getByteBuffer(bytes).slice();
            iterator2 = CollectionsKt.listOf((Object)buffer).iterator();
        } else if (bytes.isByteArrayTuple()) {
            buffer = ByteBuffer.wrap(A_Tuple.Companion.getByteArray(bytes));
            iterator2 = CollectionsKt.listOf((Object)buffer).iterator();
        } else {
            iterator2 = new Iterator<ByteBuffer>(totalBytes, oneBasedPositionLong, alignment, bytes){
                private final ByteBuffer buffer;
                private int nextSubscript;
                final /* synthetic */ int $totalBytes;
                final /* synthetic */ long $oneBasedPositionLong;
                final /* synthetic */ int $alignment;
                final /* synthetic */ AvailObject $bytes;
                {
                    this.$totalBytes = $totalBytes;
                    this.$oneBasedPositionLong = $oneBasedPositionLong;
                    this.$alignment = $alignment;
                    this.$bytes = $bytes;
                    this.buffer = ByteBuffer.allocateDirect(Math.min($totalBytes, 0x400000));
                    this.nextSubscript = 1;
                }

                public final ByteBuffer getBuffer() {
                    return this.buffer;
                }

                public final int getNextSubscript() {
                    return this.nextSubscript;
                }

                public final void setNextSubscript(int n) {
                    this.nextSubscript = n;
                }

                public boolean hasNext() {
                    return this.nextSubscript <= this.$totalBytes;
                }

                @NotNull
                public ByteBuffer next() {
                    boolean bl;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.buffer.clear();
                    int count = this.nextSubscript + this.buffer.limit() - 1;
                    if (count >= this.$totalBytes) {
                        count = this.$totalBytes;
                    } else {
                        boolean bl2;
                        long zeroBasedSubscriptAfterBuffer = this.$oneBasedPositionLong + (long)this.nextSubscript - (long)2 + (long)count;
                        long modulus = zeroBasedSubscriptAfterBuffer % (long)this.$alignment;
                        boolean bl3 = bl2 = modulus == (long)((int)modulus);
                        if (_Assertions.ENABLED && !bl2) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        if (modulus < (long)count) {
                            count -= (int)modulus;
                        }
                    }
                    A_Tuple a_Tuple = this.$bytes;
                    ByteBuffer byteBuffer = this.buffer;
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
                    A_Tuple.Companion.transferIntoByteBuffer(a_Tuple, this.nextSubscript, this.nextSubscript + count - 1, byteBuffer);
                    this.buffer.flip();
                    boolean bl4 = bl = this.buffer.limit() == count;
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    this.nextSubscript += count;
                    ByteBuffer byteBuffer2 = this.buffer;
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
                    return byteBuffer2;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        Iterator bufferIterator2 = iterator2;
        Ref.LongRef nextPosition = new Ref.LongRef();
        nextPosition.element = oneBasedPositionLong - 1L;
        Ref.ObjectRef currentBuffer = new Ref.ObjectRef();
        currentBuffer.element = bufferIterator2.next();
        Combinator.INSTANCE.recurse((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>((Ref.ObjectRef<ByteBuffer>)currentBuffer, bufferIterator2, nextPosition, oneBasedPositionLong, totalBytes, alignment, handle2, ioSystem, bytes, runtime, newFiber2, succeed2, fail2, fileChannel){
            final /* synthetic */ Ref.ObjectRef<ByteBuffer> $currentBuffer;
            final /* synthetic */ Iterator<ByteBuffer> $bufferIterator;
            final /* synthetic */ Ref.LongRef $nextPosition;
            final /* synthetic */ long $oneBasedPositionLong;
            final /* synthetic */ int $totalBytes;
            final /* synthetic */ int $alignment;
            final /* synthetic */ IOSystem.FileHandle $handle;
            final /* synthetic */ IOSystem $ioSystem;
            final /* synthetic */ AvailObject $bytes;
            final /* synthetic */ AvailRuntime $runtime;
            final /* synthetic */ A_Fiber $newFiber;
            final /* synthetic */ AvailObject $succeed;
            final /* synthetic */ AvailObject $fail;
            final /* synthetic */ AsynchronousFileChannel $fileChannel;
            {
                this.$currentBuffer = $currentBuffer;
                this.$bufferIterator = $bufferIterator;
                this.$nextPosition = $nextPosition;
                this.$oneBasedPositionLong = $oneBasedPositionLong;
                this.$totalBytes = $totalBytes;
                this.$alignment = $alignment;
                this.$handle = $handle;
                this.$ioSystem = $ioSystem;
                this.$bytes = $bytes;
                this.$runtime = $runtime;
                this.$newFiber = $newFiber;
                this.$succeed = $succeed;
                this.$fail = $fail;
                this.$fileChannel = $fileChannel;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull Function0<Unit> continueWriting) {
                boolean bl;
                Intrinsics.checkNotNullParameter(continueWriting, (String)"continueWriting");
                if (!((ByteBuffer)this.$currentBuffer.element).hasRemaining() && this.$bufferIterator.hasNext()) {
                    this.$currentBuffer.element = this.$bufferIterator.next();
                    bl = ((ByteBuffer)this.$currentBuffer.element).hasRemaining();
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                }
                if (((ByteBuffer)this.$currentBuffer.element).hasRemaining()) {
                    new SimpleCompletionHandler<V>((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(this.$nextPosition, continueWriting){
                        final /* synthetic */ Ref.LongRef $nextPosition;
                        final /* synthetic */ Function0<Unit> $continueWriting;
                        {
                            this.$nextPosition = $nextPosition;
                            this.$continueWriting = $continueWriting;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.$nextPosition.element += ((Number)$this$$receiver.getValue()).longValue();
                            this.$continueWriting.invoke();
                        }
                    }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(this.$handle, this.$runtime, this.$newFiber, this.$fail, this.$ioSystem){
                        final /* synthetic */ IOSystem.FileHandle $handle;
                        final /* synthetic */ AvailRuntime $runtime;
                        final /* synthetic */ A_Fiber $newFiber;
                        final /* synthetic */ AvailObject $fail;
                        final /* synthetic */ IOSystem $ioSystem;
                        {
                            this.$handle = $handle;
                            this.$runtime = $runtime;
                            this.$newFiber = $newFiber;
                            this.$fail = $fail;
                            this.$ioSystem = $ioSystem;
                            super(1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            WeakHashMap<IOSystem.BufferKey, Void> weakHashMap = this.$handle.getBufferKeys();
                            IOSystem.FileHandle fileHandle = this.$handle;
                            IOSystem iOSystem = this.$ioSystem;
                            WeakHashMap<IOSystem.BufferKey, Void> weakHashMap2 = weakHashMap;
                            synchronized (weakHashMap2) {
                                boolean bl = false;
                                for (IOSystem.BufferKey key : new ArrayList<E>(fileHandle.getBufferKeys().keySet())) {
                                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                                    iOSystem.discardBuffer(key);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            this.$runtime.runOutermostFunction(this.$newFiber, this.$fail, CollectionsKt.listOf((Object)AvailErrorCode.E_IO_ERROR.numericCode()));
                        }
                    }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.$fileChannel, this.$currentBuffer, this.$nextPosition){
                        final /* synthetic */ AsynchronousFileChannel $fileChannel;
                        final /* synthetic */ Ref.ObjectRef<ByteBuffer> $currentBuffer;
                        final /* synthetic */ Ref.LongRef $nextPosition;
                        {
                            this.$fileChannel = $fileChannel;
                            this.$currentBuffer = $currentBuffer;
                            this.$nextPosition = $nextPosition;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                            Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                            this.$fileChannel.write((ByteBuffer)this.$currentBuffer.element, this.$nextPosition.element, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                        }
                    });
                } else {
                    boolean bl2;
                    boolean bl3 = bl = this.$nextPosition.element == this.$oneBasedPositionLong + (long)this.$totalBytes - 1L;
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    int subscriptInTuple = 1;
                    long startOfBuffer = (this.$oneBasedPositionLong - 1L) / (long)this.$alignment * (long)this.$alignment + 1L;
                    int offsetInBuffer = (int)(this.$oneBasedPositionLong - startOfBuffer + 1L);
                    if (!this.$handle.getCanRead()) {
                        subscriptInTuple = this.$totalBytes + 1;
                    }
                    while (subscriptInTuple <= this.$totalBytes) {
                        int consumedThisTime = Math.min(this.$alignment - offsetInBuffer, this.$totalBytes - subscriptInTuple) + 1;
                        IOSystem.BufferKey key = new IOSystem.BufferKey(this.$handle, startOfBuffer);
                        Mutable<A_Tuple> bufferHolder = this.$ioSystem.getBuffer(key);
                        A_Tuple tuple2 = null;
                        tuple2 = bufferHolder.getValue();
                        if (offsetInBuffer == 1 && consumedThisTime == this.$alignment) {
                            tuple2 = A_Tuple.Companion.copyTupleFromToCanDestroy(this.$bytes, subscriptInTuple, subscriptInTuple + consumedThisTime - 1, false);
                        } else if (tuple2 != null) {
                            boolean bl4;
                            boolean bl5;
                            boolean bl6 = bl5 = A_Tuple.Companion.getTupleSize(tuple2) == this.$alignment;
                            if (_Assertions.ENABLED && !bl5) {
                                String string4 = "Assertion failed";
                                throw new AssertionError((Object)string4);
                            }
                            List parts = new ArrayList<E>();
                            if (offsetInBuffer > 1) {
                                parts.add(A_Tuple.Companion.copyTupleFromToCanDestroy(tuple2, 1, offsetInBuffer - 1, false));
                            }
                            parts.add(A_Tuple.Companion.copyTupleFromToCanDestroy(this.$bytes, subscriptInTuple, subscriptInTuple + consumedThisTime - 1, false));
                            int endInBuffer = offsetInBuffer + consumedThisTime - 1;
                            if (endInBuffer < this.$alignment) {
                                parts.add(A_Tuple.Companion.copyTupleFromToCanDestroy(tuple2, endInBuffer + 1, this.$alignment, false));
                            }
                            boolean bl7 = bl4 = parts.size() > 1;
                            if (_Assertions.ENABLED && !bl4) {
                                String string5 = "Assertion failed";
                                throw new AssertionError((Object)string5);
                            }
                            tuple2 = parts.remove(0);
                            while (!((Collection)parts).isEmpty()) {
                                A_Tuple a_Tuple = tuple2;
                                Intrinsics.checkNotNull((Object)a_Tuple);
                                tuple2 = A_Tuple.Companion.concatenateWith(a_Tuple, (A_Tuple)parts.remove(0), true);
                            }
                            A_Tuple a_Tuple = tuple2;
                            Intrinsics.checkNotNull((Object)a_Tuple);
                            boolean bl8 = bl4 = A_Tuple.Companion.getTupleSize(a_Tuple) == this.$alignment;
                            if (_Assertions.ENABLED && !bl4) {
                                String string6 = "Assertion failed";
                                throw new AssertionError((Object)string6);
                            }
                        }
                        if (tuple2 != null) {
                            tuple2 = tuple2.makeShared();
                            Mutable<A_Tuple> mutable = bufferHolder;
                            synchronized (mutable) {
                                boolean bl9 = false;
                                bufferHolder.setValue(tuple2);
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        subscriptInTuple += consumedThisTime;
                        startOfBuffer += (long)this.$alignment;
                        offsetInBuffer = 1;
                    }
                    boolean bl10 = bl2 = subscriptInTuple == this.$totalBytes + 1;
                    if (_Assertions.ENABLED && !bl2) {
                        String string7 = "Assertion failed";
                        throw new AssertionError((Object)string7);
                    }
                    A_Function a_Function = this.$succeed;
                    List<T> list2 = Collections.emptyList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList()");
                    this.$runtime.runOutermostFunction(this.$newFiber, a_Function, list2);
                }
            }
        }));
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), TupleTypeDescriptor.Companion.oneOrMoreOf(IntegerRangeTypeDescriptor.Companion.getBytes()), PrimitiveTypeDescriptor.Types.ATOM.getO(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(AvailErrorCode.E_IO_ERROR.numericCode())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getBytes()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_NOT_OPEN_FOR_WRITE, AvailErrorCode.E_EXCEEDS_VM_LIMIT};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

