/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sockets;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.NetworkChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/sockets/P_SocketSetOption;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "Options", "avail"})
public final class P_SocketSetOption
extends Primitive {
    @NotNull
    public static final P_SocketSetOption INSTANCE = new P_SocketSetOption();

    private P_SocketSetOption() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject handle2 = interpreter.argument(0);
        AvailObject options = interpreter.argument(1);
        AvailObject pojo = A_Atom.Companion.getAtomProperty(handle2, AtomDescriptor.SpecialAtom.SOCKET_KEY.getAtom());
        if (pojo.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(handle2) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        AsynchronousSocketChannel socket = (AsynchronousSocketChannel)pojo.javaObjectNotNull();
        try {
            for (MapDescriptor.Entry entry : A_Map.Companion.getMapIterable(options)) {
                NetworkChannel networkChannel;
                AvailObject key = entry.component1();
                AvailObject value = entry.component2();
                if (Options.INSTANCE.getSocketOptions()[A_Number.Companion.getExtractInt(key)] != null) {
                    boolean $i$f$cast;
                    SocketOption<?> $this$cast$iv;
                    SocketOption<?> option;
                    boolean bl = false;
                    Class<?> type = option.type();
                    if (type == Boolean.class && value.isBoolean()) {
                        $this$cast$iv = option;
                        $i$f$cast = false;
                        SocketOption booleanOption = (SocketOption)((Object)$this$cast$iv);
                        networkChannel = socket.setOption(booleanOption, (Object)A_Atom.Companion.getExtractBoolean(value));
                        continue;
                    }
                    if (type == Integer.class && A_Number.Companion.isInt(value)) {
                        $this$cast$iv = option;
                        $i$f$cast = false;
                        SocketOption intOption = (SocketOption)((Object)$this$cast$iv);
                        networkChannel = socket.setOption(intOption, (Object)A_Number.Companion.getExtractInt(value));
                        continue;
                    }
                    return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
                }
                networkChannel = null;
            }
            object = interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        catch (IllegalArgumentException e) {
            object = interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
        }
        catch (IOException e) {
            object = interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        return object;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.inclusive(0L, Options.INSTANCE.getSocketOptions().length - 1), IntegerRangeTypeDescriptor.Companion.inclusive(1L, Options.INSTANCE.getSocketOptions().length - 1), PrimitiveTypeDescriptor.Types.ANY.getO())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/sockets/P_SocketSetOption$Options;", "", "()V", "socketOptions", "", "Ljava/net/SocketOption;", "getSocketOptions", "()[Ljava/net/SocketOption;", "[Ljava/net/SocketOption;", "avail"})
    public static final class Options {
        @NotNull
        public static final Options INSTANCE = new Options();
        @NotNull
        private static final SocketOption<?>[] socketOptions;

        private Options() {
        }

        @NotNull
        public final SocketOption<?>[] getSocketOptions() {
            return socketOptions;
        }

        static {
            SocketOption[] socketOptionArray = new SocketOption[]{null, StandardSocketOptions.SO_RCVBUF, StandardSocketOptions.SO_REUSEADDR, StandardSocketOptions.SO_SNDBUF, StandardSocketOptions.SO_KEEPALIVE, StandardSocketOptions.TCP_NODELAY};
            socketOptions = socketOptionArray;
        }
    }
}

