/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.maps.A_Map;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleReplaceAtNAry;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "recursivelyUpdateMap", "Lavail/descriptor/maps/A_Map;", "targetMap", "pathTuple", "Lavail/descriptor/tuples/A_Tuple;", "pathIndex", "", "newValue", "Lavail/descriptor/representation/A_BasicObject;", "recursivelyUpdateTuple", "targetTuple", "avail"})
public final class P_TupleReplaceAtNAry
extends Primitive {
    @NotNull
    public static final P_TupleReplaceAtNAry INSTANCE = new P_TupleReplaceAtNAry();

    private P_TupleReplaceAtNAry() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CanFold};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject tuple2 = interpreter.argument(0);
        AvailObject pathTuple = interpreter.argument(1);
        AvailObject newValue = interpreter.argument(2);
        try {
            result2 = interpreter.primitiveSuccess(this.recursivelyUpdateTuple(tuple2, pathTuple, 1, newValue));
        }
        catch (AvailException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    private final A_Tuple recursivelyUpdateTuple(A_Tuple targetTuple, A_Tuple pathTuple, int pathIndex, A_BasicObject newValue) throws AvailException {
        A_Tuple a_Tuple;
        AvailObject targetIndexObject = A_Tuple.Companion.tupleAt(pathTuple, pathIndex);
        if (!A_Number.Companion.isInt(targetIndexObject)) {
            throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
        }
        int targetIndex = A_Number.Companion.getExtractInt(targetIndexObject);
        if (targetIndex > A_Tuple.Companion.getTupleSize(targetTuple)) {
            throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
        }
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple)) {
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newValue, true);
        }
        AvailObject subtuple = A_Tuple.Companion.tupleAt(targetTuple, targetIndex);
        if (subtuple.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(subtuple, pathTuple, pathIndex + 1, newValue);
            a_Tuple = A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newTuple2, true);
        } else if (subtuple.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(subtuple, pathTuple, pathIndex + 1, newValue);
            a_Tuple = A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newMap, true);
        } else {
            throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
        }
        return a_Tuple;
    }

    private final A_Map recursivelyUpdateMap(A_Map targetMap, A_Tuple pathTuple, int pathIndex, A_BasicObject newValue) throws AvailException {
        A_Map a_Map;
        AvailObject targetIndex = A_Tuple.Companion.tupleAt(pathTuple, pathIndex);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(targetMap, targetIndex);
        if (availObject == null) {
            throw new AvailException(AvailErrorCode.E_KEY_NOT_FOUND, null, 2, null);
        }
        AvailObject targetElement = availObject;
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple)) {
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newValue, true);
        }
        if (targetElement.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(targetElement, pathTuple, pathIndex + 1, newValue);
            a_Map = A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newTuple2, true);
        } else if (targetElement.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(targetElement, pathTuple, pathIndex + 1, newValue);
            a_Map = A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newMap, true);
        } else {
            throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
        }
        return a_Map;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.integerRangeType(IntegerDescriptor.Companion.fromInt(2), true, InfinityDescriptor.Companion.getPositiveInfinity(), false), TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.ANY.getO()), PrimitiveTypeDescriptor.Types.ANY.getO()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_KEY_NOT_FOUND};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

