/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks;

import avail.AvailRuntime;
import avail.io.IOSystem;
import avail.stacks.StacksSynchronizer;
import avail.utility.IO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lavail/stacks/StacksOutputFile;", "", "outputPath", "Ljava/nio/file/Path;", "synchronizer", "Lavail/stacks/StacksSynchronizer;", "fileName", "", "runtime", "Lavail/AvailRuntime;", "name", "(Ljava/nio/file/Path;Lavail/stacks/StacksSynchronizer;Ljava/lang/String;Lavail/AvailRuntime;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "outputFile", "Ljava/nio/channels/AsynchronousFileChannel;", "getOutputPath", "()Ljava/nio/file/Path;", "getSynchronizer", "()Lavail/stacks/StacksSynchronizer;", "file", "write", "", "outputText", "avail"})
public final class StacksOutputFile {
    @NotNull
    private final Path outputPath;
    @NotNull
    private final StacksSynchronizer synchronizer;
    @NotNull
    private final String name;
    @NotNull
    private AsynchronousFileChannel outputFile;

    public StacksOutputFile(@NotNull Path outputPath, @NotNull StacksSynchronizer synchronizer, @NotNull String fileName, @NotNull AvailRuntime runtime, @NotNull String name2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.outputPath = outputPath;
        this.synchronizer = synchronizer;
        this.name = name2;
        Path filePath = this.outputPath.resolve(fileName);
        Files.createDirectories(this.outputPath, new FileAttribute[0]);
        IOSystem iOSystem = runtime.getIoSystem();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.WRITE, (Enum)StandardOpenOption.TRUNCATE_EXISTING);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(\n\t\t\t\tStandardOpenOpti\u2026Option.TRUNCATE_EXISTING)");
        this.outputFile = iOSystem.openFile(filePath, (Set<? extends OpenOption>)enumSet, new FileAttribute[0]);
    }

    @NotNull
    public final Path getOutputPath() {
        return this.outputPath;
    }

    @NotNull
    public final StacksSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final AsynchronousFileChannel file() {
        return this.outputFile;
    }

    public final synchronized void write(@NotNull String outputText) {
        Intrinsics.checkNotNullParameter((Object)outputText, (String)"outputText");
        String string2 = outputText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteBuffer buffer = ByteBuffer.wrap(byArray);
        Ref.LongRef pos = new Ref.LongRef();
        this.outputFile.write(buffer, pos.element, null, (CompletionHandler)new CompletionHandler<Integer, Object>(buffer, pos, this){
            final /* synthetic */ ByteBuffer $buffer;
            final /* synthetic */ Ref.LongRef $pos;
            final /* synthetic */ StacksOutputFile this$0;
            {
                this.$buffer = $buffer;
                this.$pos = $pos;
                this.this$0 = $receiver;
            }

            public void completed(@Nullable Integer result2, @Nullable Object attachment) {
                if (this.$buffer.hasRemaining()) {
                    long l = this.$pos.element;
                    Integer n = result2;
                    Intrinsics.checkNotNull((Object)n);
                    this.$pos.element = l + (long)n.intValue();
                    StacksOutputFile.access$getOutputFile$p(this.this$0).write(this.$buffer, this.$pos.element, null, this);
                } else {
                    IO.INSTANCE.close(StacksOutputFile.access$getOutputFile$p(this.this$0));
                    this.this$0.getSynchronizer().decrementWorkCounter();
                }
            }

            public void failed(@Nullable Throwable exc, @Nullable Object attachment) {
                IO.INSTANCE.close(StacksOutputFile.access$getOutputFile$p(this.this$0));
                this.this$0.getSynchronizer().decrementWorkCounter();
            }
        });
    }

    public static final /* synthetic */ AsynchronousFileChannel access$getOutputFile$p(StacksOutputFile $this) {
        return $this.outputFile;
    }
}

