/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u000f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0002()B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b2\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b2\u0006\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\"\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010#\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010$\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010%\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010'\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0014\u0012\u00120\rR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lavail/utility/Multigraph;", "V", "E", "Lavail/utility/Multigraph$Edge;", "", "original", "(Lavail/utility/Multigraph;)V", "edges", "", "getEdges", "()Ljava/util/List;", "vertices", "", "Lavail/utility/Multigraph$VertexInGraph;", "addEdge", "", "edge", "(Lavail/utility/Multigraph$Edge;)V", "addVertex", "vertex", "(Ljava/lang/Object;)V", "containsEdge", "", "(Lavail/utility/Multigraph$Edge;)Z", "containsVertex", "(Ljava/lang/Object;)Z", "edgesFrom", "", "source", "(Ljava/lang/Object;)Ljava/util/Set;", "edgesFromTo", "destination", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "edgesTo", "excludeEdge", "excludeVertex", "includeEdge", "includeVertex", "removeEdge", "removeVertex", "Edge", "VertexInGraph", "avail"})
public final class Multigraph<V, E extends Edge<V>> {
    @NotNull
    private final Map<V, VertexInGraph> vertices;

    public Multigraph(@NotNull Multigraph<V, E> original) {
        VertexInGraph originalVertex;
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Iterable $this$forEach$iv = original.vertices.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            originalVertex = (VertexInGraph)element$iv;
            boolean bl = false;
            this.addVertex(originalVertex.getVertex());
        }
        $this$forEach$iv = original.vertices.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            originalVertex = (VertexInGraph)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = originalVertex.getOutbound().values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Set originalEdges = (Set)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = originalEdges;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Edge originalEdge = (Edge)element$iv3;
                    boolean bl3 = false;
                    this.addEdge(originalEdge);
                }
            }
        }
        this.vertices = new LinkedHashMap();
    }

    public final boolean containsVertex(V vertex) {
        return this.vertices.containsKey(vertex);
    }

    public final void addVertex(V vertex) {
        boolean bl;
        boolean bl2 = bl = !this.containsVertex(vertex);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Vertex is already present";
            throw new AssertionError((Object)string2);
        }
        this.vertices.put((VertexInGraph)vertex, new VertexInGraph(vertex));
    }

    public final boolean includeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            this.vertices.put((VertexInGraph)vertex, new VertexInGraph(vertex));
            return true;
        }
        return false;
    }

    public final void removeVertex(V vertex) {
        boolean bl = this.containsVertex(vertex);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "The vertex to remove was not present";
            throw new AssertionError((Object)string2);
        }
        VertexInGraph vertexInGraph = this.vertices.get(vertex);
        Intrinsics.checkNotNull((Object)vertexInGraph);
        VertexInGraph privateVertex = vertexInGraph;
        privateVertex.removeEdges();
        this.vertices.remove(vertex);
    }

    public final boolean excludeVertex(V vertex) {
        if (this.containsVertex(vertex)) {
            this.removeVertex(vertex);
            return true;
        }
        return false;
    }

    public final boolean containsEdge(@NotNull E edge2) {
        Set edgeSet;
        Intrinsics.checkNotNullParameter(edge2, (String)"edge");
        VertexInGraph sourceInGraph = this.vertices.get(((Edge)edge2).getSource());
        if (sourceInGraph != null && (edgeSet = sourceInGraph.getOutbound().get(this.vertices.get(((Edge)edge2).getDestination()))) != null) {
            return edgeSet.contains(edge2);
        }
        return false;
    }

    public final void addEdge(@NotNull E edge2) {
        boolean bl;
        boolean $i$a$-assert-Multigraph$addEdge$522;
        boolean bl2;
        Intrinsics.checkNotNullParameter(edge2, (String)"edge");
        Object source = ((Edge)edge2).getSource();
        Object destination = ((Edge)edge2).getDestination();
        VertexInGraph privateSource = this.vertices.get(source);
        VertexInGraph privateDestination = this.vertices.get(destination);
        boolean bl3 = bl2 = privateSource != null;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-Multigraph$addEdge$42 = false;
            String $i$a$-assert-Multigraph$addEdge$42 = "source of edge not in graph";
            throw new AssertionError((Object)$i$a$-assert-Multigraph$addEdge$42);
        }
        boolean bl4 = bl2 = privateDestination != null;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-Multigraph$addEdge$522 = false;
            String $i$a$-assert-Multigraph$addEdge$522 = "destination of edge not in graph";
            throw new AssertionError((Object)$i$a$-assert-Multigraph$addEdge$522);
        }
        VertexInGraph vertexInGraph = privateSource;
        Intrinsics.checkNotNull((Object)vertexInGraph);
        Map map = vertexInGraph.getOutbound();
        VertexInGraph vertexInGraph2 = privateDestination;
        Intrinsics.checkNotNull((Object)vertexInGraph2);
        Set set2 = map.computeIfAbsent(vertexInGraph2, Multigraph::addEdge$lambda-8);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"privateSource!!.outbound\u2026{\n\t\t\t\tmutableSetOf()\n\t\t\t}");
        Set sourceOut = set2;
        boolean bl5 = $i$a$-assert-Multigraph$addEdge$522 = !sourceOut.contains(edge2);
        if (_Assertions.ENABLED && !$i$a$-assert-Multigraph$addEdge$522) {
            boolean bl6 = false;
            String string2 = "Edge is already present";
            throw new AssertionError((Object)string2);
        }
        sourceOut.add(edge2);
        Set set3 = privateDestination.getInbound().computeIfAbsent(privateSource, Multigraph::addEdge$lambda-10);
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"privateDestination.inbou\u2026{\n\t\t\t\tmutableSetOf()\n\t\t\t}");
        Set destinationIn = set3;
        boolean bl7 = bl = !destinationIn.contains(edge2);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        destinationIn.add(edge2);
    }

    public final boolean includeEdge(@NotNull E edge2) {
        Intrinsics.checkNotNullParameter(edge2, (String)"edge");
        if (!this.containsEdge(edge2)) {
            this.addEdge(edge2);
            return true;
        }
        return false;
    }

    public final void removeEdge(@NotNull E edge2) {
        Set reverseEdgeSet;
        Set forwardEdgeSet;
        Intrinsics.checkNotNullParameter(edge2, (String)"edge");
        boolean bl = this.containsEdge(edge2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-Multigraph$removeEdge$22 = false;
            String $i$a$-assert-Multigraph$removeEdge$22 = "The edge to remove was not present";
            throw new AssertionError((Object)$i$a$-assert-Multigraph$removeEdge$22);
        }
        VertexInGraph sourceInGraph = this.vertices.get(((Edge)edge2).getSource());
        VertexInGraph destInGraph = this.vertices.get(((Edge)edge2).getDestination());
        VertexInGraph vertexInGraph = sourceInGraph;
        Intrinsics.checkNotNull((Object)vertexInGraph);
        Set set2 = forwardEdgeSet = vertexInGraph.getOutbound().get(destInGraph);
        Intrinsics.checkNotNull(set2);
        set2.remove(edge2);
        if (forwardEdgeSet.isEmpty()) {
            TypeIntrinsics.asMutableMap(sourceInGraph.getOutbound()).remove(destInGraph);
        }
        VertexInGraph vertexInGraph2 = destInGraph;
        Intrinsics.checkNotNull((Object)vertexInGraph2);
        Set set3 = reverseEdgeSet = vertexInGraph2.getInbound().get(sourceInGraph);
        Intrinsics.checkNotNull(set3);
        set3.remove(edge2);
        if (reverseEdgeSet.isEmpty()) {
            destInGraph.getInbound().remove(sourceInGraph);
        }
    }

    public final boolean excludeEdge(@NotNull E edge2) {
        Intrinsics.checkNotNullParameter(edge2, (String)"edge");
        if (this.containsEdge(edge2)) {
            this.removeEdge(edge2);
            return true;
        }
        return false;
    }

    @NotNull
    public final Set<E> edgesFromTo(V source, V destination) {
        Set set2;
        VertexInGraph sourceInGraph = this.vertices.get(source);
        VertexInGraph destInGraph = this.vertices.get(destination);
        if (sourceInGraph != null && destInGraph != null && sourceInGraph.getOutbound().containsKey(destInGraph)) {
            Set set3 = sourceInGraph.getOutbound().get(destInGraph);
            Intrinsics.checkNotNull(set3);
            set2 = CollectionsKt.toMutableSet((Iterable)set3);
        } else {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    @NotNull
    public final Set<E> edgesFrom(V source) {
        VertexInGraph sourceInGraph = this.vertices.get(source);
        if (sourceInGraph != null && !sourceInGraph.getOutbound().isEmpty()) {
            if (sourceInGraph.getOutbound().size() == 1) {
                return CollectionsKt.toSet((Iterable)((Iterable)CollectionsKt.single((Iterable)sourceInGraph.getOutbound().values())));
            }
            Set edges = new LinkedHashSet();
            Iterable $this$forEach$iv = sourceInGraph.getOutbound().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set submap = (Set)element$iv;
                boolean bl = false;
                edges.addAll(submap);
            }
            return CollectionsKt.toSet((Iterable)edges);
        }
        return SetsKt.emptySet();
    }

    @NotNull
    public final Set<E> edgesTo(V destination) {
        VertexInGraph destinationInGraph = this.vertices.get(destination);
        if (destinationInGraph != null && !destinationInGraph.getInbound().isEmpty()) {
            if (destinationInGraph.getInbound().size() == 1) {
                return CollectionsKt.toSet((Iterable)((Iterable)CollectionsKt.single((Iterable)destinationInGraph.getInbound().values())));
            }
            Set edges = new LinkedHashSet();
            Iterable $this$forEach$iv = destinationInGraph.getInbound().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set submap = (Set)element$iv;
                boolean bl = false;
                edges.addAll(submap);
            }
            return CollectionsKt.toSet((Iterable)edges);
        }
        return SetsKt.emptySet();
    }

    @NotNull
    public final Set<V> vertices() {
        return this.vertices.keySet();
    }

    @NotNull
    public final List<E> getEdges() {
        List edges = new ArrayList();
        Iterable $this$forEach$iv = this.vertices.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VertexInGraph vertexInGraph = (VertexInGraph)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = vertexInGraph.getOutbound().values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Set edgeSet = (Set)element$iv2;
                boolean bl2 = false;
                edges.addAll(edgeSet);
            }
        }
        return edges;
    }

    private static final Set addEdge$lambda-8(VertexInGraph it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addEdge$lambda-10(VertexInGraph it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lavail/utility/Multigraph$Edge;", "V", "", "source", "destination", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getDestination", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSource", "avail"})
    public static final class Edge<V> {
        private final V source;
        private final V destination;

        public Edge(V source, V destination) {
            this.source = source;
            this.destination = destination;
        }

        public final V getSource() {
            return this.source;
        }

        public final V getDestination() {
            return this.destination;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010R3\u0010\u0004\u001a$\u0012\u0014\u0012\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR3\u0010\n\u001a$\u0012\u0014\u0012\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lavail/utility/Multigraph$VertexInGraph;", "", "vertex", "(Lavail/utility/Multigraph;Ljava/lang/Object;)V", "inbound", "", "Lavail/utility/Multigraph;", "", "getInbound", "()Ljava/util/Map;", "outbound", "getOutbound", "getVertex", "()Ljava/lang/Object;", "Ljava/lang/Object;", "removeEdges", "", "avail"})
    private final class VertexInGraph {
        private final V vertex;
        @NotNull
        private final Map<VertexInGraph, Set<E>> outbound;
        @NotNull
        private final Map<VertexInGraph, Set<E>> inbound;

        public VertexInGraph(V vertex) {
            this.vertex = vertex;
            this.outbound = new LinkedHashMap();
            this.inbound = new LinkedHashMap();
        }

        public final V getVertex() {
            return this.vertex;
        }

        @NotNull
        public final Map<VertexInGraph, Set<E>> getOutbound() {
            return this.outbound;
        }

        @NotNull
        public final Map<VertexInGraph, Set<E>> getInbound() {
            return this.inbound;
        }

        public final void removeEdges() {
            Iterable $this$forEach$iv = this.outbound.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VertexInGraph destination = (VertexInGraph)element$iv;
                boolean bl = false;
                destination.inbound.remove(this);
            }
            $this$forEach$iv = this.inbound.keySet();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VertexInGraph source = (VertexInGraph)element$iv;
                boolean bl = false;
                source.outbound.remove(this);
            }
            this.outbound.clear();
            this.inbound.clear();
        }
    }
}

