/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.representation;

import avail.annotations.EnumField;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.IntegerSlotsEnum;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0013\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0000H\u0096\u0002J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0018J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0000J\u0016\u0010*\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0005J\b\u0010,\u001a\u00020\tH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\f\u00a8\u0006-"}, d2={"Lavail/descriptor/representation/BitField;", "", "integerSlot", "Lavail/descriptor/representation/IntegerSlotsEnum;", "shift", "", "bits", "presenter", "Lkotlin/Function1;", "", "(Lavail/descriptor/representation/IntegerSlotsEnum;IILkotlin/jvm/functions/Function1;)V", "getBits", "()I", "enumField", "Lavail/annotations/EnumField;", "getEnumField", "()Lavail/annotations/EnumField;", "setEnumField", "(Lavail/annotations/EnumField;)V", "getIntegerSlot", "()Lavail/descriptor/representation/IntegerSlotsEnum;", "integerSlotIndex", "getIntegerSlotIndex", "invertedMask", "", "lowMask", "mask", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPresenter", "()Lkotlin/jvm/functions/Function1;", "getShift", "compareTo", "other", "extractFromLong", "longValue", "isSamePlaceAs", "", "bitField", "replaceBits", "bitFieldValue", "toString", "avail"})
public final class BitField
implements Comparable<BitField> {
    @NotNull
    private final IntegerSlotsEnum integerSlot;
    private final int shift;
    private final int bits;
    @Nullable
    private final Function1<Integer, String> presenter;
    private final int integerSlotIndex;
    private final long lowMask;
    private final long mask;
    private final long invertedMask;
    @Nullable
    private String name;
    @Nullable
    private EnumField enumField;

    public BitField(@NotNull IntegerSlotsEnum integerSlot, int shift, int bits, @Nullable Function1<? super Integer, String> presenter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(integerSlot, "integerSlot");
        this.integerSlot = integerSlot;
        this.shift = shift;
        this.bits = bits;
        this.presenter = presenter;
        boolean bl2 = bl = this.shift == (this.shift & 0x3F);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.bits > 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl4 = bl = this.bits <= 32;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        boolean bl5 = bl = this.shift + this.bits <= 64;
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        this.integerSlotIndex = AbstractSlotsEnum.Companion.getFieldOrdinal(this.integerSlot);
        this.lowMask = (1L << this.bits) - 1L;
        this.mask = this.lowMask << this.shift;
        this.invertedMask = this.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public /* synthetic */ BitField(IntegerSlotsEnum integerSlotsEnum, int n, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            function1 = null;
        }
        this(integerSlotsEnum, n, n2, function1);
    }

    @NotNull
    public final IntegerSlotsEnum getIntegerSlot() {
        return this.integerSlot;
    }

    public final int getShift() {
        return this.shift;
    }

    public final int getBits() {
        return this.bits;
    }

    @Nullable
    public final Function1<Integer, String> getPresenter() {
        return this.presenter;
    }

    public final int getIntegerSlotIndex() {
        return this.integerSlotIndex;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string2) {
        this.name = string2;
    }

    @Nullable
    public final EnumField getEnumField() {
        return this.enumField;
    }

    public final void setEnumField(@Nullable EnumField enumField) {
        this.enumField = enumField;
    }

    @Override
    public int compareTo(@Nullable BitField other) {
        boolean bl;
        BitField bitField = other;
        Intrinsics.checkNotNull(bitField);
        boolean bl2 = bl = this.integerSlot == bitField.integerSlot;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Bit fields of different slots are incomparable";
            throw new AssertionError((Object)string2);
        }
        return Intrinsics.compare(other.shift, this.shift);
    }

    public final boolean isSamePlaceAs(@NotNull BitField bitField) {
        Intrinsics.checkNotNullParameter(bitField, "bitField");
        return this.integerSlotIndex == bitField.integerSlotIndex && this.shift == bitField.shift && this.bits == bitField.bits;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.shift + ":" + this.bits + ")";
    }

    public final int extractFromLong(long longValue) {
        return (int)(longValue >>> this.shift & this.lowMask);
    }

    public final long replaceBits(long longValue, int bitFieldValue) {
        return longValue & this.invertedMask | (long)bitFieldValue << this.shift & this.mask;
    }
}

