/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.ModuleRootErrorCode;
import avail.error.ErrorCode;
import avail.error.StandardErrorCode;
import avail.files.AvailFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailRootFileMetadata;
import org.availlang.artifact.ResourceType;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J:\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JP\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J@\u0010&\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JF\u0010*\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J8\u0010+\u001a\u00020\u00122\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u0010,\u001a\u00020\fH\u0016JF\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\f2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"00\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u00101\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u00103\u001a\u00020\u0003H\u0016R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/resolver/JarModuleRootResolver;", "Lavail/resolver/ModuleRootResolver;", "name", "", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "(Ljava/lang/String;Ljava/net/URI;Lavail/files/FileManager;)V", "artifactJar", "Lorg/availlang/artifact/jar/AvailArtifactJar;", "canSave", "", "getCanSave", "()Z", "jarFileLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "createDirectory", "qualifiedName", "completion", "Lkotlin/Function0;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "createFile", "mimeType", "createPackage", "deleteResource", "readFile", "bypassFileManager", "reference", "Lavail/resolver/ResolverReference;", "withContents", "", "Ljava/util/UUID;", "refreshResolverMetaData", "successHandler", "Lkotlin/Function1;", "", "refreshResolverReferenceDigest", "resolve", "resolvesToValidModuleRoot", "rootManifest", "forceRefresh", "withList", "", "saveFile", "fileContents", "toString", "avail"})
public final class JarModuleRootResolver
extends ModuleRootResolver {
    @NotNull
    private final ReentrantLock jarFileLock;
    @GuardedBy(value="jarFileLock")
    @NotNull
    private AvailArtifactJar artifactJar;

    public JarModuleRootResolver(@NotNull String name2, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(uri, "uri");
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        super(name2, uri, fileManager);
        this.jarFileLock = new ReentrantLock();
        this.artifactJar = new AvailArtifactJar(uri);
    }

    @Override
    public boolean getCanSave() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.jarFileLock;
        lock.lock();
        try {
            boolean bl = false;
            this.artifactJar.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean resolvesToValidModuleRoot() {
        return new File(this.getUri().getPath()).isFile();
    }

    @Override
    public void resolve(@NotNull Function1<? super ResolverReference, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.executeTask(new Function0<Unit>(this, failureHandler, successHandler){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<ResolverReference, Unit> $successHandler;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$successHandler = $successHandler;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Map map = new LinkedHashMap<K, V>();
                String rootPrefix = "/" + this.this$0.getModuleRoot().getName();
                try {
                    Object element$iv;
                    Map $this$forEach$iv;
                    Enumeration<JarEntry> $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    Map<String, byte[]> digests = null;
                    Object object = JarModuleRootResolver.access$getJarFileLock$p(this.this$0);
                    JarModuleRootResolver jarModuleRootResolver = this.this$0;
                    object.lock();
                    try {
                        boolean $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = false;
                        digests = JarModuleRootResolver.access$getArtifactJar$p(jarModuleRootResolver).extractDigestForRoot(jarModuleRootResolver.getName());
                        $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = JarModuleRootResolver.access$getArtifactJar$p(jarModuleRootResolver).getJarFileEntries();
                    }
                    finally {
                        object.unlock();
                    }
                    Enumeration<JarEntry> entries2 = $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    object = JarModuleRootResolver.access$getArtifactJar$p(this.this$0).extractFileMetadataForRoot(this.this$0.getName(), entries2, digests);
                    jarModuleRootResolver = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Object> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        AvailRootFileMetadata it = (AvailRootFileMetadata)element$iv;
                        boolean bl = false;
                        ResolverReference reference = new ResolverReference(jarModuleRootResolver, new URI(null, it.getPath(), null), it.getQualifiedName(), it.getType(), it.getMimeType(), it.getLastModified(), it.getSize(), null, digests.get(it.getPath()), 128, null);
                        map.put(it.getQualifiedName(), reference);
                    }
                    map.put(rootPrefix, new ResolverReference(this.this$0, new URI(rootPrefix), rootPrefix, ResourceType.ROOT, "", 0L, 0L, this.this$0.getModuleRoot().getName(), null, 256, null));
                    $this$forEach$iv = map;
                    jarModuleRootResolver = this.this$0;
                    $i$f$forEach = false;
                    iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        ResolverReference parentNode;
                        String parentName2;
                        Object object2 = element$iv = (Map.Entry)iterator2.next();
                        boolean bl = false;
                        String name2 = (String)object2.getKey();
                        ResolverReference reference = (ResolverReference)object2.getValue();
                        jarModuleRootResolver.getReferenceMap().put(reference.getQualifiedName(), reference);
                        if (!(((CharSequence)name2).length() > 0) || (ResolverReference)map.get(parentName2 = StringsKt.substringBeforeLast(name2, "/", "")) == null) continue;
                        boolean bl2 = reference.isResource();
                        if (bl2) {
                            parentNode.getResources().add(reference);
                            continue;
                        }
                        if (bl2) continue;
                        parentNode.getModules().add(reference);
                    }
                }
                catch (Throwable e) {
                    this.$failureHandler.invoke(ModuleRootErrorCode.MODULE_ROOT_RESOLUTION_FAILED, e);
                    return;
                }
                V v = map.get(rootPrefix);
                Intrinsics.checkNotNull(v);
                ResolverReference rootReference = (ResolverReference)v;
                this.this$0.setModuleRootTree(rootReference);
                this.$successHandler.invoke(rootReference);
            }
        });
    }

    @Override
    public void rootManifest(boolean forceRefresh, @NotNull Function1<? super List<ResolverReference>, Unit> withList, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withList, "withList");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        if (!this.getReferenceMap().isEmpty() && !forceRefresh) {
            withList.invoke(CollectionsKt.toList((Iterable)this.getReferenceMap().values()));
            return;
        }
        this.executeTask(new Function0<Unit>(this, failureHandler, withList){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$withList = $withList;
                super(0);
            }

            public final void invoke() {
                this.this$0.resolve((Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(this.$withList, this.this$0){
                    final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
                    final /* synthetic */ JarModuleRootResolver this$0;
                    {
                        this.$withList = $withList;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        this.$withList.invoke(CollectionsKt.toList((Iterable)this.this$0.getReferenceMap().values()));
                    }
                }, this.$failureHandler);
            }
        });
    }

    @Override
    public void refreshResolverMetaData(@NotNull ResolverReference reference, @NotNull Function1<? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.executeTask(new Function0<Unit>(successHandler, reference){
            final /* synthetic */ Function1<Long, Unit> $successHandler;
            final /* synthetic */ ResolverReference $reference;
            {
                this.$successHandler = $successHandler;
                this.$reference = $reference;
                super(0);
            }

            public final void invoke() {
                this.$successHandler.invoke(this.$reference.getLastModified());
            }
        });
    }

    @Override
    public void refreshResolverReferenceDigest(@NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        byte[] digest = reference.getForcedDigest();
        if (digest == null) {
            failureHandler.invoke(FileErrorCode.FILE_NOT_FOUND, new NoSuchFileException(new File(reference.getQualifiedName()), null, "Avail file " + reference.getQualifiedName() + " does not occur in Jar", 2, null));
        } else {
            successHandler.invoke((byte[])digest, (Long)reference.getLastModified());
        }
    }

    @Override
    public void createFile(@NotNull String qualifiedName2, @NotNull String mimeType, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        failureHandler.invoke(FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createPackage(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        failureHandler.invoke(FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createDirectory(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        failureHandler.invoke(FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void deleteResource(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(completion, "completion");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        failureHandler.invoke(FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void saveFile(@NotNull ResolverReference reference, @NotNull byte[] fileContents2, @NotNull Function0<Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(fileContents2, "fileContents");
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        failureHandler.invoke(FileErrorCode.PERMISSIONS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(boolean bypassFileManager, @NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Object object;
        boolean handled2;
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(withContents, "withContents");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        ResourceType[] resourceTypeArray = new ResourceType[]{ResourceType.ROOT, ResourceType.DIRECTORY, ResourceType.PACKAGE};
        if (!(!SetsKt.setOf(resourceTypeArray).contains((Object)reference.getType()))) {
            boolean bl = false;
            String string2 = reference.getQualifiedName() + " is not a file that can be read!";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!bypassFileManager && (handled2 = this.getFileManager().optionallyProvideExistingFile(reference, (Function2<? super UUID, ? super AvailFile, Unit>)new Function2<UUID, AvailFile, Unit>(reference, withContents){
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function2<byte[], UUID, Unit> $withContents;
            {
                this.$reference = $reference;
                this.$withContents = $withContents;
                super(2);
            }

            public final void invoke(@NotNull UUID uuid, @NotNull AvailFile availFile) {
                Intrinsics.checkNotNullParameter(uuid, "uuid");
                Intrinsics.checkNotNullParameter(availFile, "availFile");
                this.$reference.refresh(availFile.getLastModified(), availFile.getRawContent().length);
                this.$withContents.invoke(availFile.getRawContent(), uuid);
            }
        }, failureHandler))) {
            return;
        }
        try {
            byte[] $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
            object = this.jarFileLock;
            object.lock();
            try {
                boolean $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = false;
                String string3 = reference.getResolver().getName();
                String string4 = reference.getUri().getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue(string4, "reference.uri.schemeSpecificPart");
                $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = this.artifactJar.extractRootFile(string3, string4);
            }
            finally {
                object.unlock();
            }
            object = $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
        }
        catch (IOException e) {
            failureHandler.invoke(StandardErrorCode.IO_EXCEPTION, e);
            return;
        }
        catch (Throwable e) {
            failureHandler.invoke(StandardErrorCode.UNSPECIFIED, e);
            return;
        }
        Object fileContent2 = object;
        withContents.invoke((byte[])fileContent2, null);
    }

    @NotNull
    public String toString() {
        return this.getName() + " - " + this.getUri();
    }

    public static final /* synthetic */ ReentrantLock access$getJarFileLock$p(JarModuleRootResolver $this) {
        return $this.jarFileLock;
    }

    public static final /* synthetic */ AvailArtifactJar access$getArtifactJar$p(JarModuleRootResolver $this) {
        return $this.artifactJar;
    }
}

