/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.Sequence;
import avail.compiler.splitter.WrapState;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.ListPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010\"\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u001d\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b.J\u0018\u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020,H\u0002J\u0018\u00103\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020,H\u0002J%\u00104\u001a\u0002052\u0006\u00102\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u00106\u001a\u000205H\u0010\u00a2\u0006\u0002\b7J\u001b\u00108\u001a\u00020%2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0010\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020\r2\u0006\u00102\u001a\u00020,H\u0010\u00a2\u0006\u0002\b>J0\u0010?\u001a\u00020%2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\n\u0010C\u001a\u00060Dj\u0002`E2\u0006\u0010F\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\rJ1\u0010H\u001a\u00020%2\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010A2\n\u0010C\u001a\u00060Dj\u0002`E2\u0006\u0010F\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\bJJ \u0010K\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\rH\u0002J\b\u0010N\u001a\u00020OH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0017\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000f\u00a8\u0006P"}, d2={"Lavail/compiler/splitter/Group;", "Lavail/compiler/splitter/Expression;", "positionInName", "", "beforeDagger", "Lavail/compiler/splitter/Sequence;", "afterDagger", "(ILavail/compiler/splitter/Sequence;Lavail/compiler/splitter/Sequence;)V", "(ILavail/compiler/splitter/Sequence;)V", "getAfterDagger", "()Lavail/compiler/splitter/Sequence;", "getBeforeDagger", "hasDagger", "", "getHasDagger", "()Z", "isGroup", "isGroup$avail", "isLowerCase", "isLowerCase$avail", "maximumCardinality", "needsDoubleWrapping", "getNeedsDoubleWrapping", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "()I", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "beOptional", "", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkOneRepeatedSublistStructure", "checkType", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "emitDoubleWrappedAfterDaggerOn", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "phraseType", "emitDoubleWrappedBeforeDaggerOn", "emitOn", "Lavail/compiler/splitter/WrapState;", "wrapState", "emitOn$avail", "extractSectionCheckpointsInto", "sectionCheckpoints", "", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printGroupOccurrence", "argumentProvider", "", "Lavail/descriptor/representation/AvailObject;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "completeGroup", "printWithArguments", "arguments", "printWithArguments$avail", "tidyPushedList", "ungroupedArgCount", "listIsPushed", "toString", "", "avail"})
public final class Group
extends Expression {
    private final boolean hasDagger;
    @NotNull
    private final Sequence beforeDagger;
    @NotNull
    private final Sequence afterDagger;
    private int maximumCardinality;

    @Override
    public boolean getRecursivelyContainsReorders() {
        return this.beforeDagger.getRecursivelyContainsReorders() || this.afterDagger.getRecursivelyContainsReorders();
    }

    public final boolean getHasDagger() {
        return this.hasDagger;
    }

    @NotNull
    public final Sequence getBeforeDagger() {
        return this.beforeDagger;
    }

    @NotNull
    public final Sequence getAfterDagger() {
        return this.afterDagger;
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    public boolean isGroup$avail() {
        return true;
    }

    @Override
    public boolean isLowerCase$avail() {
        return this.beforeDagger.isLowerCase$avail() && this.afterDagger.isLowerCase$avail();
    }

    public Group(int positionInName, @NotNull Sequence beforeDagger, @NotNull Sequence afterDagger) {
        Intrinsics.checkNotNullParameter((Object)beforeDagger, (String)"beforeDagger");
        Intrinsics.checkNotNullParameter((Object)afterDagger, (String)"afterDagger");
        super(positionInName);
        this.maximumCardinality = Integer.MAX_VALUE;
        this.beforeDagger = beforeDagger;
        this.hasDagger = true;
        this.afterDagger = afterDagger;
    }

    public Group(int positionInName, @NotNull Sequence beforeDagger) {
        Intrinsics.checkNotNullParameter((Object)beforeDagger, (String)"beforeDagger");
        super(positionInName);
        this.maximumCardinality = Integer.MAX_VALUE;
        this.beforeDagger = beforeDagger;
        this.hasDagger = false;
        this.afterDagger = new Sequence(positionInName + 1);
    }

    @Override
    @NotNull
    public Group applyCaseInsensitive$avail() throws MalformedMessageException {
        if (!this.isLowerCase$avail()) {
            MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens");
            throw new KotlinNothingValueException();
        }
        return this.hasDagger ? new Group(this.getPositionInName(), this.beforeDagger.applyCaseInsensitive$avail(), this.afterDagger.applyCaseInsensitive$avail()) : new Group(this.getPositionInName(), this.beforeDagger.applyCaseInsensitive$avail());
    }

    @Override
    public int getUnderscoreCount$avail() {
        return this.beforeDagger.getUnderscoreCount$avail() + this.afterDagger.getUnderscoreCount$avail();
    }

    public final void beOptional() {
        this.maximumCardinality = 1;
    }

    private final boolean getNeedsDoubleWrapping() {
        return this.beforeDagger.getYielders().size() != 1 || this.afterDagger.getYielders().size() != 0;
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, (String)"sectionCheckpoints");
        this.beforeDagger.extractSectionCheckpointsInto$avail(sectionCheckpoints);
        this.afterDagger.extractSectionCheckpointsInto$avail(sectionCheckpoints);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (argumentType.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            throw new KotlinNothingValueException();
        }
        if (!argumentType.isTupleType()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type requiredRange = IntegerRangeTypeDescriptor.Companion.integerRangeType(IntegerDescriptor.Companion.getZero(), true, this.maximumCardinality == Integer.MAX_VALUE ? InfinityDescriptor.Companion.getPositiveInfinity() : (A_Number)IntegerDescriptor.Companion.fromInt(this.maximumCardinality + 1), false);
        if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getSizeRange(argumentType), requiredRange)) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        if (this.getNeedsDoubleWrapping()) {
            boolean bl = argumentType.isTupleType();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int argsBeforeDagger = this.beforeDagger.getYielders().size();
            int argsAfterDagger = this.afterDagger.getYielders().size();
            AvailObject expectedLower = IntegerDescriptor.Companion.fromInt(argsBeforeDagger);
            AvailObject expectedUpper = IntegerDescriptor.Companion.fromInt(argsBeforeDagger + argsAfterDagger);
            int i = 1;
            A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(argumentType);
            int limit = A_Tuple.Companion.getTupleSize(typeTuple2) + 1;
            if (i <= limit) {
                A_Type solutionType;
                while (!(solutionType = A_Type.Companion.typeAtIndex(argumentType, i)).isBottom()) {
                    if (!solutionType.isTupleType()) {
                        MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
                        throw new KotlinNothingValueException();
                    }
                    A_Type solutionTypeSizes = A_Type.Companion.getSizeRange(solutionType);
                    A_Number lower = A_Type.Companion.getLowerBound(solutionTypeSizes);
                    A_Number upper = A_Type.Companion.getUpperBound(solutionTypeSizes);
                    if (!lower.equals(expectedLower) || !upper.equals(expectedUpper)) {
                        MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_COMPLEX_GROUP);
                        throw new KotlinNothingValueException();
                    }
                    int j = 1;
                    for (Expression e : this.beforeDagger.getYielders()) {
                        e.checkType$avail(A_Type.Companion.typeAtIndex(solutionType, j++), sectionNumber);
                    }
                    for (Expression e : this.afterDagger.getYielders()) {
                        e.checkType$avail(A_Type.Companion.typeAtIndex(solutionType, j++), sectionNumber);
                    }
                    if (i == limit) break;
                    ++i;
                }
            }
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapState), (String)"wrapState");
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        A_Type sizeRange = A_Type.Companion.getSizeRange(subexpressionsTupleType2);
        A_Number minInteger = A_Type.Companion.getLowerBound(sizeRange);
        int minSize = A_Number.Companion.isInt(minInteger) ? A_Number.Companion.getExtractInt(minInteger) : Integer.MAX_VALUE;
        A_Number maxInteger = A_Type.Companion.getUpperBound(sizeRange);
        int maxSize = A_Number.Companion.isInt(maxInteger) ? A_Number.Companion.getExtractInt(maxInteger) : Integer.MAX_VALUE;
        int endOfVariation = Math.min(Math.max(A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(subexpressionsTupleType2)) + 2, Math.min(minSize, 3)), maxSize);
        boolean needsProgressCheck = this.beforeDagger.mightBeEmpty$avail(intersected);
        generator.flushDelayed();
        if (maxSize == 0) {
            generator.emit(this, ParsingOperation.EMPTY_LIST);
        } else if (!this.getNeedsDoubleWrapping()) {
            A_Type singularListType;
            A_Type[] a_TypeArray;
            A_Type innerPhraseType;
            int n = generator.getPartialListsCount();
            generator.setPartialListsCount(n + 1);
            int n2 = n = this.beforeDagger.getYielders().size() == 1 ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int n3 = n = this.afterDagger.getYielders().size() == 0 ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean hasWrapped = false;
            InstructionGenerator.Label $skip = new InstructionGenerator.Label();
            if (minSize == 0) {
                boolean bl;
                boolean bl2 = bl = maxSize > 0;
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
                generator.emitBranchForward(this, $skip);
            }
            if (!hasWrapped && this.beforeDagger.getHasSectionCheckpoints$avail()) {
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
            }
            generator.emitIf(needsProgressCheck, this, ParsingOperation.SAVE_PARSE_POSITION);
            InstructionGenerator.Label $exit = new InstructionGenerator.Label();
            for (int index2 = 1; index2 < endOfVariation; ++index2) {
                innerPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, index2);
                a_TypeArray = new A_Type[]{A_Type.Companion.getPhraseTypeExpressionType(innerPhraseType)};
                A_Type a_Type = TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray);
                a_TypeArray = new A_Type[]{innerPhraseType};
                singularListType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, a_Type, TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray));
                this.beforeDagger.emitOn$avail(singularListType, generator, hasWrapped ? WrapState.PUSHED_LIST : WrapState.SHOULD_NOT_PUSH_LIST);
                if (index2 >= minSize) {
                    generator.flushDelayed();
                    if (!hasWrapped && index2 == minSize) {
                        generator.emitWrapped(this, index2);
                        hasWrapped = true;
                    }
                    generator.emitBranchForward(this, $exit);
                }
                if (!hasWrapped && index2 == 1 && this.afterDagger.getHasSectionCheckpoints$avail()) {
                    generator.flushDelayed();
                    generator.emitWrapped(this, 1);
                    hasWrapped = true;
                }
                this.afterDagger.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.PUSHED_LIST);
                generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            }
            generator.flushDelayed();
            if (!hasWrapped) {
                generator.emitWrapped(this, endOfVariation - 1);
            }
            InstructionGenerator.Label $loopStart = new InstructionGenerator.Label();
            generator.emit($loopStart);
            innerPhraseType = A_Type.Companion.getDefaultType(subexpressionsTupleType2);
            a_TypeArray = new A_Type[]{A_Type.Companion.getPhraseTypeExpressionType(innerPhraseType)};
            A_Type a_Type = TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray);
            a_TypeArray = new A_Type[]{innerPhraseType};
            singularListType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, a_Type, TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray));
            this.beforeDagger.emitOn$avail(singularListType, generator, WrapState.PUSHED_LIST);
            if (endOfVariation < maxSize) {
                generator.flushDelayed();
                InstructionGenerator.Label $exitCheckMin = new InstructionGenerator.Label();
                generator.emitBranchForward(this, endOfVariation >= minSize ? $exit : $exitCheckMin);
                if (maxInteger.isFinite()) {
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_MOST, maxSize - 1);
                }
                this.afterDagger.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.PUSHED_LIST);
                generator.flushDelayed();
                generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
                generator.emitJumpBackward(this, $loopStart);
                if ($exitCheckMin.isUsed()) {
                    generator.emit($exitCheckMin);
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_LEAST, minSize);
                }
            }
            generator.flushDelayed();
            generator.emit($exit);
            generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            generator.emitIf(needsProgressCheck, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
            generator.emit($skip);
            int $exitCheckMin = generator.getPartialListsCount();
            generator.setPartialListsCount($exitCheckMin + -1);
        } else {
            A_Type sublistPhraseType;
            generator.flushDelayed();
            boolean hasWrapped = false;
            InstructionGenerator.Label $skip = new InstructionGenerator.Label();
            if (minSize == 0) {
                boolean $exit;
                boolean bl = $exit = maxSize > 0;
                if (_Assertions.ENABLED && !$exit) {
                    String $loopStart = "Assertion failed";
                    throw new AssertionError((Object)$loopStart);
                }
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
                generator.emitBranchForward(this, $skip);
            }
            if (!hasWrapped && (this.beforeDagger.getHasSectionCheckpoints$avail() || this.afterDagger.getHasSectionCheckpoints$avail())) {
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
            }
            generator.emitIf(needsProgressCheck, this, ParsingOperation.SAVE_PARSE_POSITION);
            InstructionGenerator.Label $exit = new InstructionGenerator.Label();
            for (int index3 = 1; index3 < endOfVariation; ++index3) {
                if (index3 >= minSize && !hasWrapped && index3 == minSize) {
                    generator.flushDelayed();
                    generator.emitWrapped(this, index3 - 1);
                    hasWrapped = true;
                }
                sublistPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, index3);
                this.emitDoubleWrappedBeforeDaggerOn(generator, sublistPhraseType);
                if (index3 >= minSize) {
                    generator.flushDelayed();
                    generator.emitBranchForward(this, $exit);
                }
                this.emitDoubleWrappedAfterDaggerOn(generator, sublistPhraseType);
                generator.flushDelayed();
                if (hasWrapped) {
                    generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                }
                generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            }
            generator.flushDelayed();
            if (!hasWrapped) {
                generator.emitWrapped(this, endOfVariation - 1);
            }
            InstructionGenerator.Label $loopStart = new InstructionGenerator.Label();
            generator.emit($loopStart);
            sublistPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, endOfVariation);
            this.emitDoubleWrappedBeforeDaggerOn(generator, sublistPhraseType);
            generator.flushDelayed();
            InstructionGenerator.Label $mergedExit = new InstructionGenerator.Label();
            if (endOfVariation < maxSize) {
                InstructionGenerator.Label $exitCheckMin = new InstructionGenerator.Label();
                generator.emitBranchForward(this, endOfVariation >= minSize ? $exit : $exitCheckMin);
                if (maxInteger.isFinite()) {
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_MOST, maxSize - 1);
                }
                this.emitDoubleWrappedAfterDaggerOn(generator, sublistPhraseType);
                generator.flushDelayed();
                generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
                generator.emitJumpBackward(this, $loopStart);
                if ($exitCheckMin.isUsed()) {
                    generator.emit($exitCheckMin);
                    generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_LEAST, minSize);
                    generator.emitJumpForward(this, $mergedExit);
                }
            }
            generator.emit($exit);
            generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
            generator.emit($mergedExit);
            generator.emitIf(needsProgressCheck, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            generator.emitIf(needsProgressCheck, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
            generator.emit($skip);
        }
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    private final void emitDoubleWrappedBeforeDaggerOn(InstructionGenerator generator, A_Type phraseType) throws SignatureException {
        boolean bl;
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        generator.setPartialListsCount(generator.getPartialListsCount() + 2);
        int argIndex = 0;
        int ungroupedArgCount = 0;
        boolean listIsPushed = false;
        for (Expression expression : this.beforeDagger.getExpressions()) {
            if (expression.getHasSectionCheckpoints$avail()) {
                this.tidyPushedList(generator, ungroupedArgCount, listIsPushed);
                ungroupedArgCount = 0;
                listIsPushed = true;
            }
            if (expression.getYieldsValue$avail()) {
                int realTypeIndex = this.beforeDagger.isReordered() ? ((Number)this.beforeDagger.getPermutation().get(argIndex - 1)).intValue() : ++argIndex;
                A_Type entryType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex);
                generator.flushDelayed();
                expression.emitOn$avail(entryType, generator, WrapState.SHOULD_NOT_PUSH_LIST);
                ++ungroupedArgCount;
                continue;
            }
            expression.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        }
        boolean bl2 = bl = argIndex == this.beforeDagger.getYielders().size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.tidyPushedList(generator, ungroupedArgCount, listIsPushed);
        generator.setPartialListsCount(generator.getPartialListsCount() - 2);
        if (this.beforeDagger.isReordered()) {
            A_Tuple permutationTuple = TupleDescriptor.Companion.tupleFromIntegerList(this.beforeDagger.getPermutation());
            int n = MessageSplitter.Companion.indexForPermutation(permutationTuple);
            generator.flushDelayed();
            generator.emit((Expression)this, ParsingOperation.PERMUTE_LIST, n);
        }
    }

    private final void emitDoubleWrappedAfterDaggerOn(InstructionGenerator generator, A_Type phraseType) {
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        generator.setPartialListsCount(generator.getPartialListsCount() + 2);
        int argIndex = this.beforeDagger.getYielders().size();
        int ungroupedArgCount = 0;
        for (Expression expression : this.afterDagger.getExpressions()) {
            if (expression.getHasSectionCheckpoints$avail()) {
                this.tidyPushedList(generator, ungroupedArgCount, true);
                ungroupedArgCount = 0;
            }
            if (expression.getYieldsValue$avail()) {
                int realTypeIndex = this.afterDagger.isReordered() ? ((Number)this.afterDagger.getPermutation().get(argIndex - 1)).intValue() : ++argIndex;
                A_Type entryType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex);
                generator.flushDelayed();
                expression.emitOn$avail(entryType, generator, WrapState.PUSHED_LIST);
                ungroupedArgCount = 0;
                continue;
            }
            expression.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        }
        this.tidyPushedList(generator, ungroupedArgCount, true);
        generator.setPartialListsCount(generator.getPartialListsCount() - 2);
        if (this.afterDagger.isReordered()) {
            int leftArgCount = this.beforeDagger.getYielders().size();
            int rightArgCount = this.afterDagger.getYielders().size();
            List adjustedPermutationList = new ArrayList();
            int i = 1;
            if (i <= leftArgCount) {
                while (true) {
                    adjustedPermutationList.add(i);
                    if (i == leftArgCount) break;
                    ++i;
                }
            }
            for (i = 0; i < rightArgCount; ++i) {
                adjustedPermutationList.add(this.afterDagger.getYielders().get(i).getExplicitOrdinal() + leftArgCount);
            }
            A_Tuple permutationTuple = TupleDescriptor.Companion.tupleFromIntegerList(adjustedPermutationList);
            int permutationIndex = MessageSplitter.Companion.indexForPermutation(permutationTuple);
            generator.flushDelayed();
            generator.emit((Expression)this, ParsingOperation.PERMUTE_LIST, permutationIndex);
        }
        boolean bl = A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(subexpressionsTupleType2)), argIndex);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    private final void tidyPushedList(InstructionGenerator generator, int ungroupedArgCount, boolean listIsPushed) {
        generator.flushDelayed();
        if (!listIsPushed) {
            generator.emitWrapped(this, ungroupedArgCount);
        } else if (ungroupedArgCount == 1) {
            generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
        } else if (ungroupedArgCount > 1) {
            generator.emitWrapped(this, ungroupedArgCount);
            generator.emit(this, ParsingOperation.CONCATENATE);
        }
    }

    @Override
    @NotNull
    public String toString() {
        Expression e;
        List strings2 = new ArrayList();
        Iterator<Expression> iterator2 = this.beforeDagger.getExpressions().iterator();
        while (iterator2.hasNext()) {
            String string2;
            StringBuilder stringBuilder;
            e = iterator2.next();
            StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u2d0.append(e);
            if (e.getCanBeReordered() && e.getExplicitOrdinal() != -1) {
                $this$toString_u24lambda_u2d0.appendCodePoint(MessageSplitter.Companion.circledNumberCodePoint(e.getExplicitOrdinal()));
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            strings2.add(string2);
        }
        if (this.hasDagger) {
            strings2.add("\u2021");
            iterator2 = this.afterDagger.getExpressions().iterator();
            while (iterator2.hasNext()) {
                e = iterator2.next();
                strings2.add(e.toString());
            }
        }
        Iterator<Expression> $this$toString_u24lambda_u2d1 = iterator2 = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)((Object)$this$toString_u24lambda_u2d1)).append("Group(");
        boolean first = true;
        for (String s : strings2) {
            if (!first) {
                ((StringBuilder)((Object)$this$toString_u24lambda_u2d1)).append(", ");
            }
            ((StringBuilder)((Object)$this$toString_u24lambda_u2d1)).append(s);
            first = false;
        }
        ((StringBuilder)((Object)$this$toString_u24lambda_u2d1)).append(')');
        String string3 = ((StringBuilder)((Object)iterator2)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        boolean needsDouble = this.getNeedsDoubleWrapping();
        Iterator<? extends A_Phrase> iterator2 = arguments;
        Intrinsics.checkNotNull(iterator2);
        A_Phrase groupArguments = iterator2.next();
        if (A_Phrase.Companion.phraseKindIsUnder(groupArguments, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
            Collection<A_Phrase> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = A_Phrase.Companion.getToken(groupArguments).literal();
            ObjectTupleDescriptor.Companion companion = ObjectTupleDescriptor.Companion;
            ListPhraseDescriptor.Companion companion2 = ListPhraseDescriptor.Companion;
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailObject availObject = (AvailObject)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, (A_BasicObject)it, StringDescriptor.Companion.stringFrom(it.toString()), null, 4, null));
            }
            collection = (List)destination$iv$iv;
            groupArguments = companion2.newListNode(companion.tupleFromList(collection));
        }
        Iterator occurrenceProvider = A_Phrase.Companion.getExpressionsTuple(groupArguments).iterator();
        while (occurrenceProvider.hasNext()) {
            boolean bl;
            AvailObject occurrence = (AvailObject)occurrenceProvider.next();
            Iterator<AvailObject> innerIterator = null;
            if (needsDouble) {
                boolean destination$iv$iv = occurrence.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType());
                if (_Assertions.ENABLED && !destination$iv$iv) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                innerIterator = A_Phrase.Companion.getExpressionsTuple(occurrence).iterator();
            } else {
                boolean destination$iv$iv = occurrence.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.getMostGeneralType());
                if (_Assertions.ENABLED && !destination$iv$iv) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                List argumentNodes = CollectionsKt.listOf((Object)occurrence);
                innerIterator = argumentNodes.iterator();
            }
            this.printGroupOccurrence(innerIterator, builder2, indent, occurrenceProvider.hasNext());
            boolean bl2 = bl = !innerIterator.hasNext();
            if (!_Assertions.ENABLED || bl) continue;
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
    }

    public final void printGroupOccurrence(@NotNull Iterator<AvailObject> argumentProvider, @NotNull StringBuilder builder2, int indent, boolean completeGroup) {
        boolean bl;
        List list2;
        Intrinsics.checkNotNullParameter(argumentProvider, (String)"argumentProvider");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append('\u00ab');
        List $this$printGroupOccurrence_u24lambda_u2d3 = list2 = (List)new ArrayList();
        boolean bl2 = false;
        $this$printGroupOccurrence_u24lambda_u2d3.addAll((Collection)this.beforeDagger.getExpressions());
        if (completeGroup && !((Collection)this.afterDagger.getExpressions()).isEmpty()) {
            $this$printGroupOccurrence_u24lambda_u2d3.add(null);
            $this$printGroupOccurrence_u24lambda_u2d3.addAll((Collection)this.afterDagger.getExpressions());
        }
        List expressionsToVisit = list2;
        boolean needsSpace = false;
        for (Expression expr : expressionsToVisit) {
            if (expr == null) {
                builder2.append('\u2021');
                needsSpace = false;
                continue;
            }
            if (needsSpace && expr.getShouldBeSeparatedOnLeft$avail()) {
                builder2.append(' ');
            }
            int oldLength = builder2.length();
            expr.printWithArguments$avail(argumentProvider, builder2, indent);
            needsSpace = expr.getShouldBeSeparatedOnRight$avail() && builder2.length() != oldLength;
        }
        boolean bl3 = bl = !argumentProvider.hasNext();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        builder2.append('\u00bb');
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return false;
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return false;
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        A_Type tupleType = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        boolean bl = tupleType.isTupleType();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(tupleType)), 0);
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                return true;
            }
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                return false;
            }
            if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE)) {
                return false;
            }
            Iterable $this$all$iv = A_Phrase.Companion.getExpressionsTuple(phrase);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AvailObject subphrase = (AvailObject)element$iv;
                    boolean bl2 = false;
                    if (this.checkOneRepeatedSublistStructure(subphrase)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOneRepeatedSublistStructure(A_Phrase phrase) {
        int n;
        int i;
        if (!this.getNeedsDoubleWrapping()) {
            return this.beforeDagger.getYielders().get(0).checkListStructure(phrase);
        }
        if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
            return true;
        }
        if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE)) {
            return false;
        }
        A_Tuple subphrases = A_Phrase.Companion.getExpressionsTuple(phrase);
        int subphrasesSize = A_Tuple.Companion.getTupleSize(subphrases);
        if (subphrasesSize == this.beforeDagger.getYielders().size()) {
            return this.beforeDagger.checkListStructure(phrase);
        }
        if (subphrasesSize != this.beforeDagger.getYielders().size() + this.afterDagger.getYielders().size()) {
            return false;
        }
        int leftSize = this.beforeDagger.getYielders().size();
        if (this.beforeDagger.isReordered() || this.afterDagger.isReordered()) {
            if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                return false;
            }
            A_Tuple actualPermutation = A_Phrase.Companion.getPermutation(phrase);
            List expectedPermutation = CollectionsKt.toMutableList((Collection)this.beforeDagger.getPermutation());
            Iterable $this$mapTo$iv = this.afterDagger.getPermutation();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                int n2 = ((Number)item$iv).intValue();
                Collection collection = expectedPermutation;
                boolean bl = false;
                collection.add((int)(it + leftSize));
            }
            if (!TupleDescriptor.Companion.tupleFromIntegerList(expectedPermutation).equals(actualPermutation)) {
                return false;
            }
        } else if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
            return false;
        }
        if ((i = 1) <= leftSize) {
            while (true) {
                if (!this.beforeDagger.getYielders().get(i - 1).checkListStructure(A_Tuple.Companion.tupleAt(subphrases, i))) {
                    return false;
                }
                if (i == leftSize) break;
                ++i;
            }
        }
        if ((i = 1) <= (n = this.afterDagger.getYielders().size())) {
            while (true) {
                if (!this.afterDagger.getYielders().get(i - 1).checkListStructure(A_Tuple.Companion.tupleAt(subphrases, i + leftSize))) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }
}

