/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.lexing;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerWholeNumberBody;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "countDigits", "", "string", "Lavail/descriptor/tuples/A_String;", "startPosition", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "readInteger", "Lavail/descriptor/numbers/A_Number;", "digitCount", "avail"})
public final class P_BootstrapLexerWholeNumberBody
extends Primitive {
    @NotNull
    public static final P_BootstrapLexerWholeNumberBody INSTANCE = new P_BootstrapLexerWholeNumberBody();

    private P_BootstrapLexerWholeNumberBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source = interpreter.argument(0);
        AvailObject sourcePositionInteger = interpreter.argument(1);
        AvailObject lineNumberInteger = interpreter.argument(2);
        int startPosition = A_Number.Companion.getExtractInt(sourcePositionInteger);
        int digitCount = this.countDigits(source, startPosition);
        A_String string2 = source.copyStringFromToCanDestroy(startPosition, startPosition + digitCount - 1, false);
        A_Number number = this.readInteger(string2, 1, digitCount);
        AvailObject token = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, string2, startPosition, A_Number.Companion.getExtractInt(lineNumberInteger), number, A_Fiber.Companion.getCurrentLexer(interpreter.fiber()), null, 32, null);
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tuple(token)};
        return interpreter.primitiveSuccess(SetDescriptor.Companion.set(a_BasicObjectArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return LexerDescriptor.Companion.lexerBodyFunctionType();
    }

    private final int countDigits(A_String string2, int startPosition) {
        boolean bl;
        int position;
        int stringSize = A_Tuple.Companion.getTupleSize(string2);
        for (position = startPosition; position <= stringSize && Character.isDigit(A_Tuple.Companion.tupleCodePointAt(string2, position)); ++position) {
        }
        boolean bl2 = bl = position > startPosition;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        return position - startPosition;
    }

    private final A_Number readInteger(A_String string2, int startPosition, int digitCount) {
        boolean i2;
        boolean bl;
        boolean bl2 = bl = digitCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (digitCount <= 18) {
            long value = 0L;
            int position = startPosition;
            for (int i2 = digitCount; 0 < i2; --i2) {
                value *= 10L;
                value += (long)Character.digit(A_Tuple.Companion.tupleCodePointAt(string2, position++), 10);
            }
            return IntegerDescriptor.Companion.fromLong(value);
        }
        int groupCount = (digitCount + 17) / 18;
        int logGroupCount = 31 - Integer.numberOfLeadingZeros(groupCount - 1);
        int rightGroupCount = 1 << logGroupCount;
        boolean bl3 = i2 = rightGroupCount < groupCount;
        if (_Assertions.ENABLED && !i2) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        boolean bl4 = i2 = rightGroupCount << 1 >= groupCount;
        if (_Assertions.ENABLED && !i2) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        boolean bl5 = i2 = logGroupCount >= 0;
        if (_Assertions.ENABLED && !i2) {
            String string6 = "Assertion failed";
            throw new AssertionError((Object)string6);
        }
        int rightCount = 18 << logGroupCount;
        A_Number leftPart = this.readInteger(string2, startPosition, digitCount - rightCount);
        A_Number rightPart = this.readInteger(string2, startPosition + digitCount - rightCount, rightCount);
        A_Number squareOfQuintillion = IntegerDescriptor.Companion.cachedSquareOfQuintillion(logGroupCount);
        A_Number shiftedLeft = A_Number.Companion.timesCanDestroy(leftPart, squareOfQuintillion, true);
        return A_Number.Companion.plusCanDestroy(shiftedLeft, rightPart, true);
    }
}

