/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.controlflow;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018R\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lavail/interpreter/primitive/controlflow/P_InvokeWithTuple;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_InvokeWithTuple
extends Primitive {
    @NotNull
    public static final P_InvokeWithTuple INSTANCE = new P_InvokeWithTuple();

    private P_InvokeWithTuple() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Invokes, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject function = interpreter.argument(0);
        AvailObject argTuple = interpreter.argument(1);
        A_Type functionType = function.kind();
        int numArgs = A_Tuple.Companion.getTupleSize(argTuple);
        A_RawFunction code = function.code();
        if (A_RawFunction.Companion.numArgs(code) != numArgs) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        A_Type tupleType = A_Type.Companion.getArgsTupleType(functionType);
        int i = 1;
        if (i <= numArgs) {
            while (true) {
                AvailObject arg;
                if (!(arg = A_Tuple.Companion.tupleAt(argTuple, i)).isInstanceOf(A_Type.Companion.typeAtIndex(tupleType, i))) {
                    return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
                }
                if (i == numArgs) break;
                ++i;
            }
        }
        interpreter.argsBuffer.clear();
        CollectionsKt.addAll((Collection)interpreter.argsBuffer, (Iterable)argTuple);
        interpreter.function = function;
        return Primitive.Result.READY_TO_INVOKE;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), TupleTypeDescriptor.Companion.getMostGeneralTupleType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type functionType = argumentTypes.get(0);
        A_Type argTupleType = argumentTypes.get(1);
        A_Type paramsType = A_Type.Companion.getArgsTupleType(functionType);
        boolean fixedSize = A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(argTupleType)).equals(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(argTupleType)));
        if (fixedSize && A_Type.Companion.getSizeRange(paramsType).equals(A_Type.Companion.getSizeRange(argTupleType)) && A_Type.Companion.isSubtypeOf(argTupleType, paramsType)) {
            return Primitive.Fallibility.CallSiteMayInvoke;
        }
        return Primitive.Fallibility.CallSiteCanFail;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        AvailObject function;
        A_RawFunction code;
        Primitive primitive2;
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type functionType = argumentTypes.get(0);
        A_Type argTupleType = argumentTypes.get(1);
        A_Type paramsType = A_Type.Companion.getArgsTupleType(functionType);
        A_Type argCountRange = A_Type.Companion.getSizeRange(argTupleType);
        A_Number argCount = A_Type.Companion.getUpperBound(argCountRange);
        if (argCount.equals(A_Type.Companion.getLowerBound(argCountRange)) && A_Type.Companion.getSizeRange(paramsType).equals(argCountRange) && A_Type.Companion.isSubtypeOf(argTupleType, paramsType) && A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(functionType), 1) && (primitive2 = (code = (function = A_Type.Companion.getInstance(functionType)).code()).codePrimitive()) != null) {
            int primArgCount = primitive2.getArgCount();
            if (A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(argCountRange), primArgCount) && A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(argCountRange), primArgCount)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)new IntRange(1, primArgCount);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(A_Type.Companion.typeAtIndex(argTupleType, (int)it));
                }
                List innerArgTypes = (List)destination$iv$iv;
                Primitive.Fallibility fallibility = primitive2.fallibilityForArgumentTypes(innerArgTypes);
                return switch (WhenMappings.$EnumSwitchMapping$0[fallibility.ordinal()]) {
                    case 1 -> primitive2.returnTypeGuaranteedByVM(code, innerArgTypes);
                    case 2 -> A_RawFunction.Companion.getReturnTypeIfPrimitiveFails(code);
                    default -> A_Type.Companion.typeUnion(A_RawFunction.Companion.getReturnTypeIfPrimitiveFails(code), primitive2.returnTypeGuaranteedByVM(code, innerArgTypes));
                };
            }
        }
        return A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(functionType), A_RawFunction.Companion.getReturnTypeIfPrimitiveFails(rawFunction));
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand functionReg = arguments.get(0);
        L2ReadBoxedOperand tupleReg = arguments.get(1);
        L2Generator generator = translator.getGenerator();
        A_Type functionType = functionReg.type();
        A_Type functionArgsType = A_Type.Companion.getArgsTupleType(functionType);
        A_Type functionTypeSizes = A_Type.Companion.getSizeRange(functionArgsType);
        A_Number upperBound = A_Type.Companion.getUpperBound(functionTypeSizes);
        if (!A_Number.Companion.isInt(upperBound) || !A_Type.Companion.getLowerBound(functionTypeSizes).equals(upperBound)) {
            return false;
        }
        int argsSize = A_Number.Companion.getExtractInt(upperBound);
        List<AvailObject> list2 = Collections.nCopies(argsSize, PrimitiveTypeDescriptor.Types.ANY.getO());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"nCopies(argsSize, Types.ANY.o)");
        List<L2ReadBoxedOperand> explodedArgumentRegisters = generator.explodeTupleIfPossible(tupleReg, list2);
        if (explodedArgumentRegisters == null) {
            return false;
        }
        A_Tuple functionArgTypes = A_Type.Companion.tupleOfTypesFromTo(functionArgsType, 1, argsSize);
        if (A_Tuple.Companion.getTupleSize(functionArgTypes) != argsSize) {
            return false;
        }
        L2BasicBlock failurePath = generator.createBasicBlock("Failed dynamic type check for P_InvokeWithTuple");
        int i = 1;
        if (i <= argsSize) {
            while (true) {
                L2ReadBoxedOperand argReg = explodedArgumentRegisters.get(i - 1);
                A_Type argType = argReg.type();
                L2ReadBoxedOperand exactTypeReg = generator.extractParameterTypeFromFunction(functionReg, i);
                AvailObject constantExactArgType = exactTypeReg.restriction().getConstantOrNull();
                if (constantExactArgType == null || !A_Type.Companion.isSubtypeOf(argType, constantExactArgType)) {
                    L2BasicBlock passedAnother = generator.createBasicBlock("Passed check for argument #" + i);
                    if (constantExactArgType != null) {
                        generator.jumpIfKindOfConstant(argReg, constantExactArgType, passedAnother, failurePath);
                    } else {
                        L2Operand[] l2OperandArray = new L2Operand[]{argReg, exactTypeReg, L2Generator.Companion.edgeTo(passedAnother), L2Generator.Companion.edgeTo(failurePath)};
                        generator.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
                    }
                    L2Generator.startBlock$default(generator, passedAnother, false, null, 6, null);
                }
                if (i == argsSize) break;
                ++i;
            }
        }
        translator.generateGeneralFunctionInvocation(functionReg, explodedArgumentRegisters, true, callSiteHelper);
        L2Generator.startBlock$default(generator, failurePath, false, null, 6, null);
        if (generator.currentlyReachable()) {
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments, false, callSiteHelper);
        }
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Primitive.Fallibility.values().length];
            nArray[Primitive.Fallibility.CallSiteCannotFail.ordinal()] = 1;
            nArray[Primitive.Fallibility.CallSiteMustFail.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

