/*
 * Decompiled with CFR 0.152.
 */
package avail.project;

import avail.anvil.AvailWorkbench;
import avail.anvil.projects.GlobalAvailConfiguration;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lavail/project/AvailProjectWorkbenchRunner;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "avail"})
public final class AvailProjectWorkbenchRunner {
    @NotNull
    public static final AvailProjectWorkbenchRunner INSTANCE = new AvailProjectWorkbenchRunner();

    private AvailProjectWorkbenchRunner() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        GlobalAvailConfiguration globalAvailConfiguration;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        File configFile = switch (args.length) {
            case 0 -> new File(AvailEnvironment.INSTANCE.getProjectRootDirectory("") + File.separator + "avail-config.json");
            case 1 -> new File(args[0]);
            default -> throw new RuntimeException("Avail project runner expects either\n\t0 arguments: The Avail Project config file, `avail-config.json`, is at the project directory where this is being run from\n\t1 argument: The path, with name, of the project config file.");
        };
        AvailEnvironment.INSTANCE.optionallyCreateAvailUserHome();
        String string2 = configFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configFile.absolutePath");
        String string3 = configFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configFile.name");
        String string4 = StringsKt.removeSuffix((String)string2, (CharSequence)string3);
        String string5 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
        String projectPath = StringsKt.removeSuffix((String)string4, (CharSequence)string5);
        AvailProject availProject = AvailProject.Companion.from(projectPath, UtilityKt.jsonObject$default((String)FilesKt.readText((File)configFile, (Charset)Charsets.UTF_8), null, (int)2, null));
        System.setProperty("darkMode", String.valueOf(availProject.getDarkMode()));
        GlobalAvailConfiguration $this$main_u24lambda_u2d0 = globalAvailConfiguration = GlobalAvailConfiguration.Companion.getGlobalConfig();
        boolean bl = false;
        String string6 = configFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"configFile.absolutePath");
        $this$main_u24lambda_u2d0.add(availProject, string6);
        GlobalAvailConfiguration globalConfig = globalAvailConfiguration;
        String string7 = configFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"configFile.absolutePath");
        AvailWorkbench.Companion.launchWorkbenchWithProject$default(AvailWorkbench.Companion, availProject, globalConfig, string7, null, false, 24, null);
    }
}

