/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import avail.anvil.actions.AvailRootEditor;
import avail.anvil.actions.CreateRootAction;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.resolver.ModuleRootResolver;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lavail/anvil/actions/CreateRootAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "avail"})
public final class CreateRootAction
extends AbstractWorkbenchAction {
    public CreateRootAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        super(workbench, "Create root", null, null, 12, null);
        this.putValue("ShortDescription", "Add a module root to the project.");
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        AvailRootEditor editor = new AvailRootEditor(this.getWorkbench(), null, 2, null);
        editor.setLocationType(AvailLocation.LocationType.project);
        Object object = this.getWorkbench().selectedModuleRoot();
        if (object == null || (object = ((ModuleRoot)object).getResolver()) == null || (object = ((ModuleRootResolver)object).getUri()) == null || (object = ((URI)object).getPath()) == null) {
            object = System.getProperty("user.dir");
        }
        Object initialPath = object;
        editor.getChooser().setCurrentDirectory(new File((String)initialPath));
        editor.setVisible(true);
        editor.dispose();
        if (!editor.getApproved()) {
            return;
        }
        AvailLocation.LocationType locationType = editor.getLocationType();
        if (locationType == null) {
            return;
        }
        AvailLocation.LocationType locationType2 = locationType;
        String relativePath = editor.relativePath();
        Scheme schema = Intrinsics.areEqual(StringsKt.substringAfterLast(relativePath, '.', ""), "jar") ? Scheme.JAR : Scheme.FILE;
        AvailLocation location = locationType2.location(this.getWorkbench().getProjectHomeDirectory(), editor.relativePath(), schema, editor.getRootNameInJar().getSelectedValue());
        String string2 = this.getWorkbench().getProjectHomeDirectory();
        String string3 = editor.getNameField().getText();
        Intrinsics.checkNotNullExpressionValue(string3, "editor.nameField.text");
        AvailProjectRoot newProjectRoot = new AvailProjectRoot(string2, string3, location, null, null, editor.getEditable().isSelected(), null, null, editor.getVisible().isSelected(), 216, null);
        AvailProject project2 = this.getWorkbench().getAvailProject$avail();
        project2.addRoot(newProjectRoot);
        ModuleRoots moduleRoots = this.getWorkbench().getRuntime().moduleRoots();
        moduleRoots.addRoot(newProjectRoot.getName(), location.getFullPath(), (Function1<? super List<String>, Unit>)new Function1<List<? extends String>, Unit>(this){
            final /* synthetic */ CreateRootAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> allFailures) {
                Intrinsics.checkNotNullParameter(allFailures, "allFailures");
                SwingUtilities.invokeLater(() -> actionPerformed.1.invoke$lambda-0(allFailures, this.this$0));
            }

            private static final void invoke$lambda-0(List $allFailures, CreateRootAction this$0) {
                String projectFilePath;
                Intrinsics.checkNotNullParameter($allFailures, "$allFailures");
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                if (!((Collection)$allFailures).isEmpty()) {
                    System.err.println(CollectionsKt.joinToString$default($allFailures, "\n", null, null, 0, null, null, 62, null));
                }
                if (((CharSequence)(projectFilePath = this$0.getWorkbench().getAvailProjectFilePath$avail())).length() > 0) {
                    JSONWriter writer = JSONWriter.Companion.newPrettyPrinterWriter();
                    this$0.getWorkbench().getAvailProject$avail().writeTo(writer);
                    FilesKt.writeText$default(new File(projectFilePath), writer.contents(), null, 2, null);
                }
                this$0.getWorkbench().getRefreshAction().runAction();
            }
        });
    }
}

