/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.CaseInsensitive;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.WrapState;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0010\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u001aJ%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b!J1\u0010\"\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010$2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\b\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lavail/compiler/splitter/Simple;", "Lavail/compiler/splitter/Expression;", "token", "Lavail/descriptor/tuples/A_String;", "tokenIndex", "", "positionInName", "(Lavail/descriptor/tuples/A_String;II)V", "isLowerCase", "", "isLowerCase$avail", "()Z", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "wrapState", "emitOn$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "toString", "", "Companion", "avail"})
public final class Simple
extends Expression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_String token;
    private final int tokenIndex;
    @NotNull
    private static final String charactersThatLikeSpacesBefore = "(=+-\u00d7\u00f7*/\u2227\u2228:?\u2286\u2208";
    @NotNull
    private static final String charactersThatLikeSpacesAfter = ")]=+-\u00d7\u00f7*/\u2227\u2228\u2192\u2286\u2208";

    public Simple(@NotNull A_String token, int tokenIndex, int positionInName) {
        Intrinsics.checkNotNullParameter(token, "token");
        super(positionInName);
        this.token = token;
        this.tokenIndex = tokenIndex;
    }

    @Override
    public boolean isLowerCase$avail() {
        String nativeString = this.token.asNativeString();
        String string2 = nativeString.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.equals(string2, nativeString, true);
    }

    @Override
    @NotNull
    public Expression applyCaseInsensitive$avail() {
        return new CaseInsensitive(this.getPositionInName(), this);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        if (_Assertions.ENABLED) {
            boolean bl = false;
            String string2 = "checkType() should not be called for Simple expressions";
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter((Object)wrapState, "wrapState");
        ParsingOperation op = generator.getCaseInsensitive() ? ParsingOperation.PARSE_PART_CASE_INSENSITIVELY : ParsingOperation.PARSE_PART;
        generator.emit((Expression)this, op, this.tokenIndex);
        return wrapState;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.token + ")";
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments2, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        builder2.append(this.token.asNativeString());
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        boolean bl;
        boolean bl2 = bl = A_Tuple.Companion.getTupleSize(this.token) > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int firstCharacter = A_Tuple.Companion.tupleCodePointAt(this.token, 1);
        return Character.isUnicodeIdentifierPart(firstCharacter) || StringsKt.indexOf$default((CharSequence)charactersThatLikeSpacesBefore, (char)firstCharacter, 0, false, 6, null) >= 0;
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        boolean bl;
        boolean bl2 = bl = A_Tuple.Companion.getTupleSize(this.token) > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int lastCharacter = A_Tuple.Companion.tupleCodePointAt(this.token, A_Tuple.Companion.getTupleSize(this.token));
        return Character.isUnicodeIdentifierPart(lastCharacter) || StringsKt.indexOf$default((CharSequence)charactersThatLikeSpacesAfter, (char)lastCharacter, 0, false, 6, null) >= 0;
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter(phrase, "phrase");
        throw new RuntimeException("checkListStructure() inapplicable for Simple expression.");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lavail/compiler/splitter/Simple$Companion;", "", "()V", "charactersThatLikeSpacesAfter", "", "charactersThatLikeSpacesBefore", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

