/*
 * Decompiled with CFR 0.152.
 */
package avail.dispatch;

import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lavail/dispatch/LookupStatistics;", "", "baseName", "", "report", "Lavail/performance/StatisticReport;", "(Ljava/lang/String;Lavail/performance/StatisticReport;)V", "timeStats", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lavail/performance/Statistic;", "kotlin.jvm.PlatformType", "createStatistic", "index", "", "recordDynamicLookup", "", "nanos", "", "depth", "avail"})
public final class LookupStatistics {
    @NotNull
    private final String baseName;
    @NotNull
    private final StatisticReport report;
    @NotNull
    private final AtomicReference<Statistic[]> timeStats;

    public LookupStatistics(@NotNull String baseName, @NotNull StatisticReport report) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter((Object)report, "report");
        this.baseName = baseName;
        this.report = report;
        int n = 0;
        Statistic[] statisticArray = new Statistic[3];
        LookupStatistics lookupStatistics = this;
        while (n < 3) {
            int n2 = n++;
            statisticArray[n2] = this.createStatistic(n2);
        }
        Statistic[] statisticArray2 = statisticArray;
        lookupStatistics.timeStats = new AtomicReference<Statistic[]>(statisticArray2);
    }

    private final Statistic createStatistic(int index2) {
        return new Statistic(this.report, this.baseName + " (depth = " + index2 + ")");
    }

    public final void recordDynamicLookup(double nanos, int depth) {
        if (depth == 0) {
            return;
        }
        Statistic[] stats = this.timeStats.get();
        while (depth >= stats.length) {
            int n = depth + 3;
            Statistic[] statisticArray = new Statistic[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                statisticArray[n2] = n2 < stats.length ? stats[n2] : this.createStatistic(n2);
            }
            Statistic[] biggerStats = statisticArray;
            stats = this.timeStats.compareAndSet(stats, biggerStats) ? biggerStats : this.timeStats.get();
        }
        Statistic.record$default(stats[depth], nanos, 0, 2, null);
    }
}

