/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.pojos.PojoFieldDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.pojos.PrimitiveHelper;
import avail.utility.Mutable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/pojos/P_BindPojoStaticField;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BindPojoStaticField
extends Primitive {
    @NotNull
    public static final P_BindPojoStaticField INSTANCE = new P_BindPojoStaticField();

    private P_BindPojoStaticField() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject pojoType = interpreter.argument(0);
        AvailObject fieldName = interpreter.argument(1);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader != null) {
            availLoader.statementCanBeSummarized(false);
        }
        Mutable<Object> errorOut = new Mutable<Object>(null);
        Field field = PrimitiveHelper.INSTANCE.lookupField$avail(pojoType, fieldName, errorOut);
        if (field == null) {
            Object v2 = errorOut.getValue();
            Intrinsics.checkNotNull(v2);
            return interpreter.primitiveFailure((AvailErrorCode)v2);
        }
        Field field2 = field;
        if (!Modifier.isStatic(field2.getModifiers())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE);
        }
        Type type2 = field2.getGenericType();
        Intrinsics.checkNotNullExpressionValue(type2, "field.genericType");
        A_Type fieldType = PojoTypeDescriptor.Companion.resolvePojoType(type2, MapDescriptor.Companion.getEmptyMap());
        AvailObject variable = PojoFieldDescriptor.Companion.pojoFieldVariableForInnerType(RawPojoDescriptor.Companion.equalityPojo(field2), RawPojoDescriptor.Companion.rawNullPojo(), fieldType);
        return interpreter.primitiveSuccess(variable);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceMetaDescriptor.Companion.anyMeta(), TupleTypeDescriptor.Companion.getStringType()), VariableTypeDescriptor.Companion.getMostGeneralVariableType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE, AvailErrorCode.E_JAVA_FIELD_REFERENCE_IS_AMBIGUOUS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

