/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.variables.A_Variable;
import avail.interpreter.execution.Interpreter;
import avail.performance.Statistic;
import avail.serialization.FourStreamIndexCompressor;
import avail.serialization.SerializerInstruction;
import avail.serialization.SerializerOperand;
import avail.serialization.SerializerOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 32\u00020\u0001:\u00013B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\bH\u0002J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\bJ\u0006\u0010&\u001a\u00020'J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b2R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/serialization/Serializer;", "", "output", "Ljava/io/OutputStream;", "module", "Lavail/descriptor/module/A_Module;", "lookupPumpedObject", "Lkotlin/Function1;", "Lavail/descriptor/representation/A_BasicObject;", "", "(Ljava/io/OutputStream;Lavail/descriptor/module/A_Module;Lkotlin/jvm/functions/Function1;)V", "compressor", "Lavail/serialization/FourStreamIndexCompressor;", "encounteredObjects", "", "Lavail/serialization/SerializerInstruction;", "getModule", "()Lavail/descriptor/module/A_Module;", "getOutput", "()Ljava/io/OutputStream;", "serializedObjectsList", "", "variablesToAssign", "", "Lavail/descriptor/variables/A_Variable;", "workStack", "Ljava/util/ArrayDeque;", "Lkotlin/Function0;", "", "checkAtom", "atom", "Lavail/descriptor/atoms/A_Atom;", "checkAtom$avail", "compressedObjectIndex", "obj", "compressedObjectIndex$avail", "newInstruction", "serialize", "serializedObjectsTuple", "Lavail/descriptor/representation/AvailObject;", "traceOne", "traceOne$avail", "writeByte", "byteValue", "writeByte$avail", "writeInt", "intValue", "writeInt$avail", "writeShort", "shortValue", "writeShort$avail", "Companion", "avail"})
public final class Serializer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final OutputStream output;
    @Nullable
    private final A_Module module;
    @NotNull
    private final Function1<A_BasicObject, Integer> lookupPumpedObject;
    @NotNull
    private final Map<A_BasicObject, SerializerInstruction> encounteredObjects;
    @NotNull
    private final List<A_BasicObject> serializedObjectsList;
    @NotNull
    private final Set<A_Variable> variablesToAssign;
    @NotNull
    private final FourStreamIndexCompressor compressor;
    @NotNull
    private final ArrayDeque<Function0<Unit>> workStack;
    @NotNull
    private static final Map<AvailObject, Integer> specialObjects;
    @NotNull
    private static final Map<AvailObject, Integer> specialAtoms;
    @NotNull
    private static final Map<A_String, AvailObject> specialAtomsByName;

    public Serializer(@NotNull OutputStream output, @Nullable A_Module module, @NotNull Function1<? super A_BasicObject, Integer> lookupPumpedObject) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(lookupPumpedObject, "lookupPumpedObject");
        this.output = output;
        this.module = module;
        this.lookupPumpedObject = lookupPumpedObject;
        this.encounteredObjects = new LinkedHashMap();
        this.serializedObjectsList = new ArrayList();
        this.variablesToAssign = new LinkedHashSet();
        this.compressor = new FourStreamIndexCompressor();
        this.workStack = new ArrayDeque(1000);
    }

    public /* synthetic */ Serializer(OutputStream outputStream, A_Module a_Module, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            a_Module = null;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(outputStream, a_Module, function1);
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    @Nullable
    public final A_Module getModule() {
        return this.module;
    }

    @NotNull
    public final AvailObject serializedObjectsTuple() {
        return ObjectTupleDescriptor.Companion.tupleFromList(this.serializedObjectsList).makeShared();
    }

    public final void checkAtom$avail(@NotNull A_Atom atom) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        if (this.module == null) {
            return;
        }
        A_Module atomModule = A_Atom.Companion.getIssuingModule(atom);
        if (atomModule.isNil()) {
            return;
        }
        boolean bl = A_Module.Companion.hasAncestor(this.module, atomModule);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final void writeByte$avail(int byteValue) {
        boolean bl;
        boolean bl2 = bl = (byteValue & 0xFF) == byteValue;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            this.output.write(byteValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void writeShort$avail(int shortValue) {
        boolean bl;
        boolean bl2 = bl = (shortValue & 0xFFFF) == shortValue;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            this.output.write(shortValue >> 8);
            this.output.write(shortValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void writeInt$avail(int intValue) {
        try {
            this.output.write(intValue >> 24);
            this.output.write(intValue >> 16);
            this.output.write(intValue >> 8);
            this.output.write(intValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final int compressedObjectIndex$avail(@NotNull A_BasicObject obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        SerializerInstruction serializerInstruction = this.encounteredObjects.get(obj);
        Intrinsics.checkNotNull(serializerInstruction);
        SerializerInstruction instruction2 = serializerInstruction;
        boolean bl = instruction2.getHasBeenWritten();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.compressor.compress(instruction2.getIndex$avail());
    }

    private final SerializerInstruction newInstruction(A_BasicObject obj) {
        SerializerOperation operation = specialObjects.containsKey(obj) ? SerializerOperation.SPECIAL_OBJECT : obj.serializerOperation();
        return new SerializerInstruction(operation, obj, this);
    }

    public final void traceOne$avail(@NotNull AvailObject obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        long before = System.nanoTime();
        SerializerInstruction serializerInstruction = this.encounteredObjects.computeIfAbsent(obj, arg_0 -> Serializer.traceOne$lambda-1(this, obj, arg_0));
        Intrinsics.checkNotNullExpressionValue(serializerInstruction, "encounteredObjects.compu\u2026stingIndex\n\t\t\t\t}\n\t\t\t}\n\t\t}");
        SerializerInstruction instruction2 = serializerInstruction;
        if (!instruction2.getHasBeenWritten()) {
            boolean bl;
            this.workStack.addLast(new Function0<Unit>(instruction2, this){
                final /* synthetic */ SerializerInstruction $instruction;
                final /* synthetic */ Serializer this$0;
                {
                    this.$instruction = $instruction;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (!this.$instruction.getHasBeenWritten()) {
                        Object object;
                        this.$instruction.setIndex$avail(Serializer.access$getCompressor$p(this.this$0).currentIndex());
                        this.$instruction.writeTo(this.this$0);
                        AvailObject availObject = this.$instruction.getNewObject();
                        if (availObject != null) {
                            object = availObject;
                            List list2 = Serializer.access$getSerializedObjectsList$p(this.this$0);
                            A_BasicObject p0 = (A_BasicObject)object;
                            boolean bl = false;
                            list2.add(p0);
                        }
                        boolean bl = this.$instruction.getHasBeenWritten();
                        if (_Assertions.ENABLED && !bl) {
                            object = "Assertion failed";
                            throw new AssertionError(object);
                        }
                        Serializer.access$getCompressor$p(this.this$0).incrementIndex();
                    }
                }
            });
            SerializerOperand[] operands = instruction2.getOperation$avail().getOperands$avail();
            boolean bl2 = bl = instruction2.getSubobjectsCount() == operands.length;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            for (int i = instruction2.getSubobjectsCount() - 1; -1 < i; --i) {
                SerializerOperand operand = operands[i];
                A_BasicObject a_BasicObject = instruction2.getSubobject(i);
                Intrinsics.checkNotNull(a_BasicObject, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                AvailObject operandValue = (AvailObject)a_BasicObject;
                this.workStack.addLast(new Function0<Unit>(operand, operandValue, this){
                    final /* synthetic */ SerializerOperand $operand;
                    final /* synthetic */ AvailObject $operandValue;
                    final /* synthetic */ Serializer this$0;
                    {
                        this.$operand = $operand;
                        this.$operandValue = $operandValue;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$operand.trace(this.$operandValue, this.this$0);
                    }
                });
            }
            if (instruction2.getOperation$avail().isVariableCreation$avail() && obj.value().getNotNil()) {
                this.variablesToAssign.add(obj);
                this.workStack.addFirst(new Function0<Unit>(this, obj){
                    final /* synthetic */ Serializer this$0;
                    final /* synthetic */ AvailObject $obj;
                    {
                        this.this$0 = $receiver;
                        this.$obj = $obj;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.traceOne$avail(this.$obj.value());
                    }
                });
            }
            Statistic.record$default(instruction2.getOperation$avail().getTraceStat$avail(), System.nanoTime() - before, 0, 2, null);
        }
    }

    public final void serialize(@NotNull A_BasicObject obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        AvailObject strongObject = (AvailObject)obj;
        this.traceOne$avail(strongObject);
        while (!this.workStack.isEmpty()) {
            this.workStack.removeLast().invoke();
        }
        for (A_Variable variable : this.variablesToAssign) {
            Statistic $this$iv = SerializerOperation.ASSIGN_TO_VARIABLE.getSerializeStat$avail();
            int index$iv = Interpreter.Companion.currentIndexOrZero();
            boolean $i$f$record = false;
            long before$iv = System.nanoTime();
            boolean bl = false;
            boolean bl2 = variable.value().getNotNil();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            SerializerInstruction assignment = new SerializerInstruction(SerializerOperation.ASSIGN_TO_VARIABLE, variable, this);
            assignment.setIndex$avail(this.compressor.currentIndex());
            assignment.writeTo(this);
            boolean bl3 = assignment.getHasBeenWritten();
            if (_Assertions.ENABLED && !bl3) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.compressor.incrementIndex();
            Unit result$iv = Unit.INSTANCE;
            $this$iv.getStatistics()[index$iv].record(System.nanoTime() - before$iv);
        }
        this.variablesToAssign.clear();
        Statistic $this$iv = SerializerOperation.CHECKPOINT.getSerializeStat$avail();
        int index$iv = Interpreter.Companion.currentIndexOrZero();
        boolean $i$f$record = false;
        long before$iv = System.nanoTime();
        boolean bl = false;
        SerializerInstruction checkpoint = new SerializerInstruction(SerializerOperation.CHECKPOINT, strongObject, this);
        checkpoint.setIndex$avail(this.compressor.currentIndex());
        checkpoint.writeTo(this);
        boolean bl4 = checkpoint.getHasBeenWritten();
        if (_Assertions.ENABLED && !bl4) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        this.compressor.incrementIndex();
        Unit result$iv = Unit.INSTANCE;
        $this$iv.getStatistics()[index$iv].record(System.nanoTime() - before$iv);
    }

    private static final SerializerInstruction traceOne$lambda-1(Serializer this$0, AvailObject $obj, A_BasicObject it) {
        SerializerInstruction serializerInstruction;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($obj, "$obj");
        Intrinsics.checkNotNullParameter(it, "it");
        SerializerInstruction it2 = serializerInstruction = this$0.newInstruction($obj);
        boolean bl = false;
        int existingIndex = ((Number)this$0.lookupPumpedObject.invoke($obj)).intValue();
        if (existingIndex != 0) {
            it2.setIndex$avail(existingIndex);
        }
        return serializerInstruction;
    }

    public static final /* synthetic */ FourStreamIndexCompressor access$getCompressor$p(Serializer $this) {
        return $this.compressor;
    }

    public static final /* synthetic */ List access$getSerializedObjectsList$p(Serializer $this) {
        return $this.serializedObjectsList;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Pair it;
        Object object;
        Iterable $this$associateTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)AvailRuntime.Companion.getSpecialObjects());
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to(((IndexedValue)((Object)it)).getValue(), ((IndexedValue)((Object)it)).getIndex());
            object.put(it.getFirst(), it.getSecond());
        }
        specialObjects = destination$iv$iv;
        $this$associate$iv = CollectionsKt.withIndex((Iterable)AvailRuntime.Companion.getSpecialAtoms());
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to(((IndexedValue)((Object)it)).getValue(), ((IndexedValue)((Object)it)).getIndex());
            object.put(it.getFirst(), it.getSecond());
        }
        specialAtoms = destination$iv$iv;
        Iterable $this$associateBy$iv = specialAtoms.keySet();
        boolean $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        $this$associateTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            object = (AvailObject)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(A_Atom.Companion.getAtomName((A_Atom)it2), element$iv$iv);
        }
        specialAtomsByName = destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lavail/serialization/Serializer$Companion;", "", "()V", "specialAtoms", "", "Lavail/descriptor/representation/AvailObject;", "", "specialAtomsByName", "Lavail/descriptor/tuples/A_String;", "getSpecialAtomsByName$avail", "()Ljava/util/Map;", "specialObjects", "indexOfSpecialAtom", "obj", "Lavail/descriptor/atoms/A_Atom;", "indexOfSpecialAtom$avail", "indexOfSpecialObject", "Lavail/descriptor/representation/A_BasicObject;", "indexOfSpecialObject$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<A_String, AvailObject> getSpecialAtomsByName$avail() {
            return specialAtomsByName;
        }

        public final int indexOfSpecialObject$avail(@NotNull A_BasicObject obj) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Integer n = (Integer)specialObjects.get(obj);
            return n != null ? n : -1;
        }

        public final int indexOfSpecialAtom$avail(@NotNull A_Atom obj) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Integer n = (Integer)specialAtoms.get(obj);
            return n != null ? n : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

