/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.interpreter.execution.Interpreter;
import avail.performance.Statistic;
import avail.serialization.Serializer;
import avail.serialization.SerializerOperation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011\u00a8\u0006#"}, d2={"Lavail/serialization/SerializerInstruction;", "", "operation", "Lavail/serialization/SerializerOperation;", "obj", "Lavail/descriptor/representation/A_BasicObject;", "serializer", "Lavail/serialization/Serializer;", "(Lavail/serialization/SerializerOperation;Lavail/descriptor/representation/A_BasicObject;Lavail/serialization/Serializer;)V", "hasBeenWritten", "", "getHasBeenWritten", "()Z", "newValue", "", "index", "getIndex$avail", "()I", "setIndex$avail", "(I)V", "newObject", "Lavail/descriptor/representation/AvailObject;", "getNewObject", "()Lavail/descriptor/representation/AvailObject;", "getOperation$avail", "()Lavail/serialization/SerializerOperation;", "subobjects", "", "[Lavail/descriptor/representation/A_BasicObject;", "subobjectsCount", "getSubobjectsCount", "getSubobject", "subscript", "writeTo", "", "avail"})
public final class SerializerInstruction {
    @NotNull
    private final SerializerOperation operation;
    @Nullable
    private final AvailObject newObject;
    @NotNull
    private final A_BasicObject[] subobjects;
    private int index;

    public SerializerInstruction(@NotNull SerializerOperation operation, @NotNull A_BasicObject obj, @NotNull Serializer serializer) {
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        this.operation = operation;
        this.newObject = this.operation.getShouldCaptureObject() ? (AvailObject)obj : null;
        this.subobjects = this.operation.decompose$avail((AvailObject)obj, serializer);
        this.index = Integer.MIN_VALUE;
    }

    @NotNull
    public final SerializerOperation getOperation$avail() {
        return this.operation;
    }

    @Nullable
    public final AvailObject getNewObject() {
        return this.newObject;
    }

    public final int getIndex$avail() {
        return this.index;
    }

    public final void setIndex$avail(int newValue) {
        boolean bl;
        boolean bl2 = bl = this.index == Integer.MIN_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.index = newValue;
    }

    public final boolean getHasBeenWritten() {
        return this.index != Integer.MIN_VALUE;
    }

    public final int getSubobjectsCount() {
        return this.subobjects.length;
    }

    @NotNull
    public final A_BasicObject getSubobject(int subscript) {
        return this.subobjects[subscript];
    }

    public final void writeTo(@NotNull Serializer serializer) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Statistic $this$iv = this.operation.getSerializeStat$avail();
        int index$iv = Interpreter.Companion.currentIndexOrZero();
        boolean $i$f$record = false;
        long before$iv = System.nanoTime();
        boolean bl = false;
        this.operation.writeObject$avail(this.subobjects, serializer);
        Unit result$iv = Unit.INSTANCE;
        $this$iv.getStatistics()[index$iv].record(System.nanoTime() - before$iv);
    }
}

