/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.jar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifact;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.DigestUtility;
import org.availlang.artifact.PackageType;
import org.availlang.artifact.UtilityKt;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020\u0011R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/availlang/artifact/jar/AvailArtifactJarBuilder;", "", "outputLocation", "", "implementationVersion", "implementationTitle", "availArtifactManifest", "Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "jarManifestMainClass", "customManifestItems", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/availlang/artifact/manifest/AvailArtifactManifest;Ljava/lang/String;Ljava/util/Map;)V", "added", "", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "addDir", "", "dir", "Ljava/io/File;", "addFile", "file", "targetDirectory", "addJar", "jarFile", "Ljava/util/jar/JarFile;", "addRoot", "targetRoot", "Lorg/availlang/artifact/roots/AvailRoot;", "addZip", "zipFile", "Ljava/util/zip/ZipFile;", "canonicalizePath", "path", "finish", "avail-artifact"})
public final class AvailArtifactJarBuilder {
    @NotNull
    private final String outputLocation;
    @NotNull
    private final String implementationVersion;
    @NotNull
    private final String implementationTitle;
    @NotNull
    private final AvailArtifactManifest availArtifactManifest;
    @NotNull
    private final String jarManifestMainClass;
    @NotNull
    private final Map<String, String> customManifestItems;
    @NotNull
    private final JarOutputStream jarOutputStream;
    @NotNull
    private final Set<String> added;

    public AvailArtifactJarBuilder(@NotNull String outputLocation, @NotNull String implementationVersion, @NotNull String implementationTitle, @NotNull AvailArtifactManifest availArtifactManifest, @NotNull String jarManifestMainClass, @NotNull Map<String, String> customManifestItems) {
        Intrinsics.checkNotNullParameter(outputLocation, "outputLocation");
        Intrinsics.checkNotNullParameter(implementationVersion, "implementationVersion");
        Intrinsics.checkNotNullParameter(implementationTitle, "implementationTitle");
        Intrinsics.checkNotNullParameter(availArtifactManifest, "availArtifactManifest");
        Intrinsics.checkNotNullParameter(jarManifestMainClass, "jarManifestMainClass");
        Intrinsics.checkNotNullParameter(customManifestItems, "customManifestItems");
        this.outputLocation = outputLocation;
        this.implementationVersion = implementationVersion;
        this.implementationTitle = implementationTitle;
        this.availArtifactManifest = availArtifactManifest;
        this.jarManifestMainClass = jarManifestMainClass;
        this.customManifestItems = customManifestItems;
        this.added = new LinkedHashSet();
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue(attributes, "manifest.mainAttributes");
        Map map = attributes;
        Attributes.Name name2 = Attributes.Name.MANIFEST_VERSION;
        Object object = "1.0";
        map.put(name2, object);
        Attributes attributes2 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue(attributes2, "manifest.mainAttributes");
        map = attributes2;
        name2 = new Attributes.Name("Build-Time");
        object = UtilityKt.getFormattedNow();
        map.put(name2, object);
        Attributes attributes3 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue(attributes3, "manifest.mainAttributes");
        map = attributes3;
        name2 = Attributes.Name.IMPLEMENTATION_VERSION;
        object = this.implementationVersion;
        map.put(name2, object);
        Attributes attributes4 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue(attributes4, "manifest.mainAttributes");
        map = attributes4;
        name2 = Attributes.Name.IMPLEMENTATION_TITLE;
        object = this.implementationTitle;
        map.put(name2, object);
        Map<String, String> $this$forEach$iv = this.customManifestItems;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            Attributes attributes5 = manifest2.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue(attributes5, "manifest.mainAttributes");
            Map map2 = attributes5;
            map2.put(new Attributes.Name(k), v);
        }
        if (((CharSequence)this.jarManifestMainClass).length() > 0) {
            Attributes attributes6 = manifest2.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue(attributes6, "manifest.mainAttributes");
            map = attributes6;
            Attributes.Name name3 = Attributes.Name.MAIN_CLASS;
            object = this.jarManifestMainClass;
            map.put(name3, object);
        }
        this.jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.outputLocation), manifest2);
        this.jarOutputStream.putNextEntry(new JarEntry("META-INF/"));
        this.jarOutputStream.closeEntry();
        this.added.add("META-INF/");
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/"));
        this.jarOutputStream.closeEntry();
        this.added.add("avail-artifact-contents/");
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/artifact-descriptor"));
        this.jarOutputStream.write(PackageType.JAR.getArtifactDescriptor().getSerializedFileContent());
        this.jarOutputStream.closeEntry();
        this.added.add("avail-artifact-contents/artifact-descriptor");
    }

    public /* synthetic */ AvailArtifactJarBuilder(String string2, String string3, String string4, AvailArtifactManifest availArtifactManifest, String string5, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string5 = "";
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string2, string3, string4, availArtifactManifest, string5, map);
    }

    private final String canonicalizePath(String path) {
        return StringsKt.replace$default(path, "\\", "/", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addRoot(@NotNull AvailRoot targetRoot) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(targetRoot, "targetRoot");
        String rootPath = StringsKt.removePrefix(targetRoot.getAbsolutePath(), (CharSequence)Scheme.JAR.getPrefix());
        File root = new File(rootPath);
        if (!root.isDirectory()) {
            if (StringsKt.endsWith$default(rootPath, "jar", false, 2, null)) {
                this.addJar(new JarFile(root));
                return;
            }
            throw new AvailArtifactException("Failed to add module root, " + targetRoot.getName() + "; provided root path, " + rootPath + ", is not a directory");
        }
        String rootEntryName = this.canonicalizePath("avail-artifact-contents/" + targetRoot.getName() + "/");
        this.jarOutputStream.putNextEntry(new JarEntry(rootEntryName));
        this.added.add(rootEntryName);
        this.jarOutputStream.closeEntry();
        String sourceDirPrefix = AvailArtifact.Companion.rootArtifactSourcesDir(targetRoot.getName());
        Sequence sequence = FilesKt.walk$default(root, null, 1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            String string2 = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string2, "file.absolutePath");
            String pathRelativeName = this.canonicalizePath(sourceDirPrefix + StringsKt.removePrefix(string2, (CharSequence)rootPath) + (file2.isDirectory() ? "/" : ""));
            this.jarOutputStream.putNextEntry(new JarEntry(pathRelativeName));
            this.added.add(pathRelativeName);
            if (file2.isFile()) {
                byte[] fileBytes = FilesKt.readBytes(file2);
                this.jarOutputStream.write(fileBytes);
            }
            this.jarOutputStream.closeEntry();
        }
        String entryName = this.canonicalizePath(AvailArtifact.Companion.rootArtifactDigestDirPath(targetRoot.getName()) + "/Avail-Digests/");
        this.jarOutputStream.putNextEntry(new JarEntry(entryName));
        this.added.add(entryName);
        this.jarOutputStream.closeEntry();
        String digestFileName = AvailArtifact.Companion.rootArtifactDigestFilePath(targetRoot.getName());
        String digest = DigestUtility.INSTANCE.createDigest(rootPath, targetRoot.getDigestAlgorithm());
        this.jarOutputStream.putNextEntry(new JarEntry(digestFileName));
        byte[] byArray = digest.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this.jarOutputStream.write(byArray);
        this.added.add(digestFileName);
        this.jarOutputStream.closeEntry();
    }

    /*
     * Unable to fully structure code
     */
    public final void addJar(@NotNull JarFile jarFile) {
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        jarSimpleName = new File(jarFile.getName()).getName();
        v0 = jarFile.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(v0, "jarFile.entries().asIterator()");
        $this$forEach$iv = v0;
        $i$f$forEach = false;
        var5_5 = $this$forEach$iv;
        while (var5_5.hasNext()) {
            it = element$iv = var5_5.next();
            $i$a$-forEach-AvailArtifactJarBuilder$addJar$1 = false;
            var9_9 = it.getName();
            if (var9_9 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var9_9.hashCode()) {
                case -893091530: {
                    if (var9_9.equals("avail-artifact-contents/avail-artifact-manifest.txt")) {
                        tmp = 1;
                    }
                    break;
                }
                case -770367560: {
                    if (var9_9.equals("avail-artifact-contents/")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1700358998: {
                    if (var9_9.equals("META-INF/")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1539143842: {
                    if (var9_9.equals("META-INF/MANIFEST.MF")) {
                        tmp = 3;
                    }
                    break;
                }
                case 1016944530: {
                    if (var9_9.equals("avail-artifact-contents/artifact-descriptor")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    adjustedManifest = "META-INF/" + jarSimpleName + "/MANIFEST.MF";
                    this.jarOutputStream.putNextEntry(new JarEntry(adjustedManifest));
                    this.added.add(adjustedManifest);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                case 4: {
                    adjustedDescriptor = this.canonicalizePath("avail-artifact-contents/" + jarSimpleName + "/artifact-descriptor");
                    this.jarOutputStream.putNextEntry(new JarEntry(adjustedDescriptor));
                    this.added.add(adjustedDescriptor);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                case 1: {
                    adjustedAvailManifest = this.canonicalizePath("avail-artifact-contents/" + jarSimpleName + "/avail-artifact-manifest.txt");
                    entry = new JarEntry(adjustedAvailManifest);
                    this.jarOutputStream.putNextEntry(entry);
                    this.added.add(adjustedAvailManifest);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (this.added.contains(it.getName())) break;
                    this.jarOutputStream.putNextEntry(new JarEntry(it));
                    if (it.getSize() > 0L) {
                        bytes = new byte[(int)it.getSize()];
                        stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                        stream.readFully(bytes);
                        this.jarOutputStream.write(bytes);
                    }
                    v1 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(v1, "it.name");
                    this.added.add(v1);
                    this.jarOutputStream.closeEntry();
                }
                case 2: 
            }
        }
    }

    public final void addZip(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Iterator<? extends ZipEntry> iterator2 = zipFile.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "zipFile.entries().asIterator()");
        Iterator<? extends ZipEntry> $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator<? extends ZipEntry> iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            ZipEntry element$iv;
            ZipEntry it = element$iv = iterator3.next();
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "it.name");
            if (this.added.add(string2)) continue;
            this.jarOutputStream.putNextEntry(new JarEntry(it));
            if (it.getSize() > 0L) {
                byte[] bytes = new byte[(int)it.getSize()];
                DataInputStream stream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(it), (int)it.getSize()));
                stream.readFully(bytes);
                this.jarOutputStream.write(bytes);
            }
            this.jarOutputStream.closeEntry();
        }
    }

    public final void addFile(@NotNull File file2, @NotNull String targetDirectory) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(targetDirectory, "targetDirectory");
        if (!(!file2.isDirectory())) {
            boolean $i$a$-require-AvailArtifactJarBuilder$addFile$22 = false;
            String $i$a$-require-AvailArtifactJarBuilder$addFile$22 = "Expected " + file2 + " to be a file not a directory!";
            throw new IllegalArgumentException($i$a$-require-AvailArtifactJarBuilder$addFile$22.toString());
        }
        String pathRelativeName = this.canonicalizePath(targetDirectory + "/" + file2.getName());
        if (!this.added.add(pathRelativeName)) {
            this.jarOutputStream.putNextEntry(new JarEntry(pathRelativeName));
            if (file2.isFile()) {
                byte[] fileBytes = FilesKt.readBytes(file2);
                this.jarOutputStream.write(fileBytes);
            }
            this.jarOutputStream.closeEntry();
        }
    }

    public final void addDir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        if (!dir.isDirectory()) {
            boolean $i$a$-require-AvailArtifactJarBuilder$addDir$22 = false;
            String $i$a$-require-AvailArtifactJarBuilder$addDir$22 = "Expected " + dir + " to be a directory!";
            throw new IllegalArgumentException($i$a$-require-AvailArtifactJarBuilder$addDir$22.toString());
        }
        Sequence $this$forEach$iv = FilesKt.walk$default(dir, null, 1, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            File file2 = (File)element$iv;
            boolean bl = false;
            String string2 = dir.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "dir.name");
            this.addFile(file2, string2);
        }
    }

    public final void finish() {
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/avail-artifact-manifest.txt"));
        byte[] byArray = this.availArtifactManifest.getFileContent().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this.jarOutputStream.write(byArray);
        this.added.add("avail-artifact-contents/avail-artifact-manifest.txt");
        this.jarOutputStream.closeEntry();
        this.jarOutputStream.finish();
        this.jarOutputStream.flush();
        this.jarOutputStream.close();
    }
}

