/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.instruction;

import avail.compiler.AvailCodeGenerator;
import avail.compiler.instruction.AvailVariableAccessNote;
import avail.descriptor.tuples.A_Tuple;
import avail.io.NybbleOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH&R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u001e"}, d2={"Lavail/compiler/instruction/AvailInstruction;", "", "relevantTokens", "Lavail/descriptor/tuples/A_Tuple;", "(Lavail/descriptor/tuples/A_Tuple;)V", "isOuterUse", "", "()Z", "lineNumber", "", "getLineNumber", "()I", "getRelevantTokens", "()Lavail/descriptor/tuples/A_Tuple;", "setRelevantTokens", "fixUsageFlags", "", "localData", "", "Lavail/compiler/instruction/AvailVariableAccessNote;", "outerData", "codeGenerator", "Lavail/compiler/AvailCodeGenerator;", "writeLineNumberDeltasOn", "encodedLineNumberDeltas", "currentLineNumber", "writeNybblesOn", "aStream", "Lavail/io/NybbleOutputStream;", "Companion", "avail"})
public abstract class AvailInstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private A_Tuple relevantTokens;

    public AvailInstruction(@NotNull A_Tuple relevantTokens) {
        Intrinsics.checkNotNullParameter((Object)relevantTokens, (String)"relevantTokens");
        this.relevantTokens = relevantTokens;
    }

    @NotNull
    public final A_Tuple getRelevantTokens() {
        return this.relevantTokens;
    }

    public final void setRelevantTokens(@NotNull A_Tuple a_Tuple) {
        Intrinsics.checkNotNullParameter((Object)a_Tuple, (String)"<set-?>");
        this.relevantTokens = a_Tuple;
    }

    public boolean isOuterUse() {
        return false;
    }

    public abstract void writeNybblesOn(@NotNull NybbleOutputStream var1);

    /*
     * WARNING - void declaration
     */
    public int writeLineNumberDeltasOn(@NotNull List<Integer> encodedLineNumberDeltas, int currentLineNumber) {
        int n;
        Intrinsics.checkNotNullParameter(encodedLineNumberDeltas, (String)"encodedLineNumberDeltas");
        int nextLineNumber = this.getLineNumber();
        if (nextLineNumber == -1) {
            encodedLineNumberDeltas.add(0);
            n = currentLineNumber;
        } else {
            void var3_3;
            int delta = nextLineNumber - currentLineNumber;
            int encodedDelta = Math.abs(delta) << 1 | delta >>> 31;
            encodedLineNumberDeltas.add(encodedDelta);
            n = var3_3;
        }
        return n;
    }

    public void fixUsageFlags(@NotNull List<AvailVariableAccessNote> localData, @NotNull List<AvailVariableAccessNote> outerData, @NotNull AvailCodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter(localData, (String)"localData");
        Intrinsics.checkNotNullParameter(outerData, (String)"outerData");
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
    }

    public final int getLineNumber() {
        return A_Tuple.Companion.getTupleSize(this.relevantTokens) == 0 ? -1 : A_Tuple.Companion.tupleAt(this.relevantTokens, 1).lineNumber();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lavail/compiler/instruction/AvailInstruction$Companion;", "", "()V", "writeIntegerOn", "", "anInteger", "", "aStream", "Lavail/io/NybbleOutputStream;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeIntegerOn(int anInteger, @NotNull NybbleOutputStream aStream) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)aStream, (String)"aStream");
            boolean bl2 = bl = anInteger >= 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "only positive integers";
                throw new AssertionError((Object)string2);
            }
            if (anInteger < 10) {
                aStream.write(anInteger);
            } else if (anInteger < 58) {
                aStream.write(anInteger - 10 + 160 >>> 4);
                aStream.write(anInteger - 10 + 160 & 0xF);
            } else if (anInteger < 314) {
                aStream.write(13);
                aStream.write(anInteger - 58 >>> 4);
                aStream.write(anInteger - 58 & 0xF);
            } else if (anInteger < 65536) {
                aStream.write(14);
                aStream.write(anInteger >>> 12);
                aStream.write(anInteger >>> 8 & 0xF);
                aStream.write(anInteger >>> 4 & 0xF);
                aStream.write(anInteger & 0xF);
            } else {
                aStream.write(15);
                aStream.write(anInteger >>> 28);
                aStream.write(anInteger >>> 24 & 0xF);
                aStream.write(anInteger >>> 20 & 0xF);
                aStream.write(anInteger >>> 16 & 0xF);
                aStream.write(anInteger >>> 12 & 0xF);
                aStream.write(anInteger >>> 8 & 0xF);
                aStream.write(anInteger >>> 4 & 0xF);
                aStream.write(anInteger & 0xF);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

