/*
 * Decompiled with CFR 0.152.
 */
package avail.error;

import avail.builder.ModuleRootErrorCodeRange;
import avail.error.ErrorCode;
import avail.error.ErrorCodeRange;
import avail.error.InvalidErrorCode;
import avail.error.InvalidErrorCodeRange;
import avail.error.StandardErrorCodeRange;
import avail.files.FileErrorCodeRange;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lavail/error/ErrorCodeRangeRegistry;", "", "()V", "ranges", "", "Lkotlin/ranges/IntRange;", "Lavail/error/ErrorCodeRange;", "errorCode", "Lavail/error/ErrorCode;", "code", "", "inRange", "register", "", "errorCodeRange", "avail"})
public final class ErrorCodeRangeRegistry {
    @NotNull
    public static final ErrorCodeRangeRegistry INSTANCE = new ErrorCodeRangeRegistry();
    @NotNull
    private static final Map<IntRange, ErrorCodeRange> ranges = new LinkedHashMap();

    private ErrorCodeRangeRegistry() {
    }

    public final void register(@NotNull ErrorCodeRange errorCodeRange) {
        Intrinsics.checkNotNullParameter((Object)errorCodeRange, (String)"errorCodeRange");
        if (ranges.containsKey(errorCodeRange.getRange())) {
            ErrorCodeRange errorCodeRange2 = ranges.get(errorCodeRange.getRange());
            Intrinsics.checkNotNull((Object)errorCodeRange2);
            ErrorCodeRange existing = errorCodeRange2;
            throw new IllegalStateException("Attempted to add " + errorCodeRange.getName() + " (" + errorCodeRange.getRange() + "), but " + existing.getName() + " already occupies that range.");
        }
        for (ErrorCodeRange range : ranges.values()) {
            IntRange intRange = errorCodeRange.getRange();
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = range.getRange().getFirst();
            if (!(n <= n3 ? n3 <= n2 : false)) {
                intRange = errorCodeRange.getRange();
                n = intRange.getFirst();
                n2 = intRange.getLast();
                n3 = range.getRange().getLast();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (!bl) continue;
            }
            throw new IllegalStateException("Attempted to add " + errorCodeRange.getName() + " (" + errorCodeRange.getRange() + "), but " + range.getName() + " already occupies that range.");
        }
        ranges.put(errorCodeRange.getRange(), errorCodeRange);
    }

    private final IntRange inRange(int code) {
        for (IntRange range : ranges.keySet()) {
            if (!range.contains(code)) continue;
            return range;
        }
        return null;
    }

    @NotNull
    public final ErrorCode errorCode(int code) {
        IntRange intRange = this.inRange(code);
        if (intRange == null) {
            return new InvalidErrorCode(code, new InvalidErrorCodeRange(code));
        }
        IntRange range = intRange;
        ErrorCodeRange errorCodeRange = ranges.get(range);
        Intrinsics.checkNotNull((Object)errorCodeRange);
        return errorCodeRange.errorCode(code);
    }

    static {
        INSTANCE.register(StandardErrorCodeRange.INSTANCE);
        INSTANCE.register(ModuleRootErrorCodeRange.INSTANCE);
        INSTANCE.register(FileErrorCodeRange.INSTANCE);
    }
}

