/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CREATE_MAP;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_CREATE_MAP
extends L2Operation {
    @NotNull
    public static final L2_CREATE_MAP INSTANCE = new L2_CREATE_MAP();

    private L2_CREATE_MAP() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED_VECTOR.named("keys"), L2OperandType.READ_BOXED_VECTOR.named("values"), L2OperandType.WRITE_BOXED.named("new map")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand keys = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand values = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand map = (L2WriteBoxedOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(map.registerString());
        builder2.append(" \u2190 {");
        int limit = keys.getElements().size();
        for (int i = 0; i < limit; ++i) {
            if (i > 0) {
                builder2.append(", ");
            }
            L2ReadBoxedOperand key = (L2ReadBoxedOperand)keys.getElements().get(i);
            L2ReadBoxedOperand value = (L2ReadBoxedOperand)values.getElements().get(i);
            builder2.append(key.registerString());
            builder2.append("\u2192");
            builder2.append(value.registerString());
        }
        builder2.append('}');
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedVectorOperand keys = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand values = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand map = (L2WriteBoxedOperand)instruction2.operand(2);
        MapDescriptor.Companion.getEmptyMapMethod().generateCall(method);
        int limit = keys.getElements().size();
        boolean bl2 = bl = limit == values.getElements().size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (int i = 0; i < limit; ++i) {
            translator.load(method, (L2Register)((L2ReadBoxedOperand)keys.getElements().get(i)).register());
            translator.load(method, (L2Register)((L2ReadBoxedOperand)values.getElements().get(i)).register());
            A_Map.Companion.getMapAtPuttingStaticMethod().generateCall(method);
        }
        translator.store(method, (L2Register)map.register());
    }
}

