/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lavail/interpreter/levelTwo/operation/L2_EXTRACT_TAG_ORDINAL;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "generateReplacement", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_EXTRACT_TAG_ORDINAL
extends L2Operation {
    @NotNull
    public static final L2_EXTRACT_TAG_ORDINAL INSTANCE = new L2_EXTRACT_TAG_ORDINAL();

    private L2_EXTRACT_TAG_ORDINAL() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("value"), L2OperandType.WRITE_INT.named("metatag ordinal")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ').append(tagOrdinal.registerString()).append(" \u2190 TAG(").append(value.registerString()).append(")");
    }

    @Override
    public void generateReplacement(@NotNull L2Instruction instruction2, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        A_Type type = value.type();
        TypeTag baseTag = A_Type.Companion.getInstanceTag(type);
        if (!(baseTag.ordinal() != baseTag.getHighOrdinal() || baseTag.isSubtagOf(TypeTag.TOP_TYPE_TAG) && baseTag != TypeTag.BOTTOM_TYPE_TAG)) {
            L2Operand[] l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(baseTag.ordinal()), tagOrdinal};
            regenerator2.getTargetGenerator().addInstruction(L2_MOVE_CONSTANT.unboxedInt, l2OperandArray);
            return;
        }
        super.generateReplacement(instruction2, regenerator2);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        translator.load(method, (L2Register)value.register());
        AbstractDescriptor.Companion.getStaticTypeTagOrdinalMethod().generateCall(method);
        translator.store(method, (L2Register)tagOrdinal.register());
    }
}

