/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.processes;

import avail.AvailRuntime;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.processes.P_ExecuteAttachedExternalProcess;
import avail.io.ProcessInputChannel;
import avail.io.ProcessOutputChannel;
import avail.io.TextInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/processes/P_ExecuteAttachedExternalProcess;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_ExecuteAttachedExternalProcess
extends Primitive {
    @NotNull
    public static final P_ExecuteAttachedExternalProcess INSTANCE = new P_ExecuteAttachedExternalProcess();

    private P_ExecuteAttachedExternalProcess() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Object environmentMap;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(6);
        AvailObject processArgsTuple = interpreter.argument(0);
        AvailObject optDir = interpreter.argument(1);
        AvailObject optEnvironment = interpreter.argument(2);
        AvailObject succeed2 = interpreter.argument(3);
        AvailObject fail2 = interpreter.argument(4);
        AvailObject priority = interpreter.argument(5);
        Iterable $this$map$iv = processArgsTuple;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AvailObject availObject = (AvailObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asNativeString());
        }
        List processArgs = (List)destination$iv$iv;
        ProcessBuilder builder2 = new ProcessBuilder(processArgs);
        builder2.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder2.redirectOutput(ProcessBuilder.Redirect.PIPE);
        builder2.redirectError(ProcessBuilder.Redirect.PIPE);
        if (A_Tuple.Companion.getTupleSize(optDir) == 1) {
            File dir = new File(A_Tuple.Companion.tupleAt(optDir, 1).asNativeString());
            builder2.directory(dir);
        }
        if (A_Tuple.Companion.getTupleSize(optEnvironment) == 1) {
            void $this$associateTo$iv$iv;
            Object item$iv$iv;
            AvailObject oldEnvironmentMap = A_Tuple.Companion.tupleAt(optEnvironment, 1);
            Iterable<MapDescriptor.Entry> $this$associate$iv = A_Map.Companion.getMapIterable(oldEnvironmentMap);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            item$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                MapDescriptor.Entry entry = (MapDescriptor.Entry)element$iv$iv;
                boolean bl = false;
                AvailObject k = entry.component1();
                AvailObject v = entry.component2();
                entry = TuplesKt.to((Object)k.asNativeString(), (Object)v.asNativeString());
                map.put(entry.getFirst(), entry.getSecond());
            }
            Map newEnvironmentMap = destination$iv$iv2;
            environmentMap = builder2.environment();
            environmentMap.clear();
            environmentMap.putAll(newEnvironmentMap);
        }
        A_Fiber current = interpreter.fiber();
        try {
            Process $this$attempt_u24lambda_u2d1 = builder2.start();
            boolean bl = false;
            InputStream inputStream = $this$attempt_u24lambda_u2d1.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            environmentMap = new Triple((Object)new TextInterface(new ProcessInputChannel(inputStream), new ProcessOutputChannel(new PrintStream($this$attempt_u24lambda_u2d1.getOutputStream())), new ProcessOutputChannel(new PrintStream($this$attempt_u24lambda_u2d1.getOutputStream()))), (Object)succeed2, (Object)CollectionsKt.emptyList());
        }
        catch (SecurityException e) {
            environmentMap = new Triple((Object)A_Fiber.Companion.getTextInterface(current), (Object)fail2, (Object)CollectionsKt.listOf((Object)AvailErrorCode.E_PERMISSION_DENIED.numericCode()));
        }
        catch (IOException e) {
            environmentMap = new Triple((Object)A_Fiber.Companion.getTextInterface(current), (Object)fail2, (Object)CollectionsKt.listOf((Object)AvailErrorCode.E_NO_EXTERNAL_PROCESS.numericCode()));
        }
        iterable = environmentMap;
        TextInterface textInterface = (TextInterface)iterable.component1();
        AvailObject toRun = (AvailObject)iterable.component2();
        List args = (List)iterable.component3();
        AvailRuntime runtime = interpreter.runtime;
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, PrimitiveTypeDescriptor.Types.TOP.getO(), runtime, textInterface, A_Number.Companion.getExtractInt(priority), null, attempt.newFiber.1.INSTANCE, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        toRun.makeShared();
        runtime.runOutermostFunction(newFiber2, toRun, args);
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[6];
        a_BasicObjectArray[0] = TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.getStringType());
        a_BasicObjectArray[1] = TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.getStringType());
        a_BasicObjectArray[2] = TupleTypeDescriptor.Companion.zeroOrOneOf(MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.getStringType()));
        a_BasicObjectArray[3] = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_NO_EXTERNAL_PROCESS};
        a_BasicObjectArray[4] = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
        a_BasicObjectArray[5] = IntegerRangeTypeDescriptor.Companion.getBytes();
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_NO_EXTERNAL_PROCESS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

