/*
 * Decompiled with CFR 0.152.
 */
package avail.performance;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lavail/performance/ReportingUnit;", "", "ranges", "", "Lavail/performance/ReportingUnit$Range;", "(Ljava/lang/String;I[Lavail/performance/ReportingUnit$Range;)V", "[Lavail/performance/ReportingUnit$Range;", "describe", "", "count", "", "mean", "", "standardDeviation", "isMean", "", "describe$avail", "NANOSECONDS", "BYTES", "DIMENSIONLESS_DOUBLE", "DIMENSIONLESS_INTEGRAL", "Range", "avail"})
public final class ReportingUnit
extends Enum<ReportingUnit> {
    @NotNull
    private final Range[] ranges;
    public static final /* enum */ ReportingUnit NANOSECONDS;
    public static final /* enum */ ReportingUnit BYTES;
    public static final /* enum */ ReportingUnit DIMENSIONLESS_DOUBLE;
    public static final /* enum */ ReportingUnit DIMENSIONLESS_INTEGRAL;
    private static final /* synthetic */ ReportingUnit[] $VALUES;

    private ReportingUnit(Range ... ranges) {
        this.ranges = ranges;
    }

    @NotNull
    public final String describe$avail(long count, double mean, double standardDeviation, boolean isMean) {
        double total = (double)count * mean;
        for (Range range : this.ranges) {
            if (!(range.getLow$avail() <= total) || !(total < range.getHigh$avail())) continue;
            String format = isMean ? range.getMeanFormat$avail() : range.getFormat$avail();
            Object[] objectArray = new Object[]{total * range.getScale$avail(), standardDeviation * range.getScale$avail()};
            String string2 = String.format(format, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(\n\t\t\t\t\tformat,\n\t\t\t\u2026dDeviation * range.scale)");
            return string2;
        }
        return "N/A";
    }

    public static ReportingUnit[] values() {
        return (ReportingUnit[])$VALUES.clone();
    }

    public static ReportingUnit valueOf(String value) {
        return Enum.valueOf(ReportingUnit.class, value);
    }

    static {
        Range[] rangeArray = new Range[]{new Range(9.999995E8, Double.POSITIVE_INFINITY, 1.0E-9, "%, 8.3f s         ", null, 16, null), new Range(999999.5, 9.999995E8, 1.0E-6, "    %, 8.3f ms    ", null, 16, null), new Range(Double.NEGATIVE_INFINITY, 999999.5, 0.001, "        %, 8.3f \u00b5s", null, 16, null)};
        NANOSECONDS = new ReportingUnit(rangeArray);
        rangeArray = new Range[]{new Range(9.999999995E11, Double.POSITIVE_INFINITY, 1.0E-12, "%, 8.3f TB        ", null, 16, null), new Range(9.999995E8, 9.999999995E11, 1.0E-9, "%, 8.3f GB        ", null, 16, null), new Range(999999.5, 9.999995E8, 1.0E-6, "    %, 8.3f MB    ", null, 16, null), new Range(999.5, 999999.5, 0.001, "        %, 8.3f KB", null, 16, null), new Range(Double.NEGATIVE_INFINITY, 999.5, 1.0, "        %, 8.0f B ", null, 16, null)};
        BYTES = new ReportingUnit(rangeArray);
        rangeArray = new Range[]{new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, "%, 10.3f", null, 16, null)};
        DIMENSIONLESS_DOUBLE = new ReportingUnit(rangeArray);
        rangeArray = new Range[]{new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, "%, 8.0f", "%, 8.3f\u00b1%,8.3f")};
        DIMENSIONLESS_INTEGRAL = new ReportingUnit(rangeArray);
        $VALUES = reportingUnitArray = new ReportingUnit[]{ReportingUnit.NANOSECONDS, ReportingUnit.BYTES, ReportingUnit.DIMENSIONLESS_DOUBLE, ReportingUnit.DIMENSIONLESS_INTEGRAL};
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B1\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lavail/performance/ReportingUnit$Range;", "", "low", "", "high", "scale", "format", "", "meanFormat", "(DDDLjava/lang/String;Ljava/lang/String;)V", "getFormat$avail", "()Ljava/lang/String;", "getHigh$avail", "()D", "getLow$avail", "getMeanFormat$avail", "getScale$avail", "avail"})
    public static final class Range {
        private final double low;
        private final double high;
        private final double scale;
        @NotNull
        private final String format;
        @NotNull
        private final String meanFormat;

        @JvmOverloads
        public Range(double low, double high, double scale, @NotNull String format, @NotNull String meanFormat) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)meanFormat, (String)"meanFormat");
            this.low = low;
            this.high = high;
            this.scale = scale;
            this.format = format;
            this.meanFormat = meanFormat;
        }

        public /* synthetic */ Range(double d, double d2, double d3, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                string3 = string2;
            }
            this(d, d2, d3, string2, string3);
        }

        public final double getLow$avail() {
            return this.low;
        }

        public final double getHigh$avail() {
            return this.high;
        }

        public final double getScale$avail() {
            return this.scale;
        }

        @NotNull
        public final String getFormat$avail() {
            return this.format;
        }

        @NotNull
        public final String getMeanFormat$avail() {
            return this.meanFormat;
        }

        @JvmOverloads
        public Range(double low, double high, double scale, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            this(low, high, scale, format, null, 16, null);
        }
    }
}

